@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin.inputs

import com.pulumi.azurenative.powerbidedicated.inputs.AutoScaleVCoreSkuArgs.builder
import com.pulumi.azurenative.powerbidedicated.kotlin.enums.VCoreSkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents the SKU name and Azure pricing tier for auto scale v-core resource.
 * @property capacity The capacity of an auto scale v-core resource.
 * @property name Name of the SKU level.
 * @property tier The name of the Azure pricing tier to which the SKU applies.
 */
public data class AutoScaleVCoreSkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<String>,
    public val tier: Output<Either<String, VCoreSkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerbidedicated.inputs.AutoScaleVCoreSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbidedicated.inputs.AutoScaleVCoreSkuArgs =
        com.pulumi.azurenative.powerbidedicated.inputs.AutoScaleVCoreSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutoScaleVCoreSkuArgs].
 */
@PulumiTagMarker
public class AutoScaleVCoreSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<String>? = null

    private var tier: Output<Either<String, VCoreSkuTier>>? = null

    /**
     * @param value The capacity of an auto scale v-core resource.
     */
    @JvmName("oqikhacnicpyjcdt")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Name of the SKU level.
     */
    @JvmName("swabrkkopmghnivn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("kovsgwbillnefejr")
    public suspend fun tier(`value`: Output<Either<String, VCoreSkuTier>>) {
        this.tier = value
    }

    /**
     * @param value The capacity of an auto scale v-core resource.
     */
    @JvmName("wvilfbtlsbxmfhoa")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Name of the SKU level.
     */
    @JvmName("kelayxynplaailxc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("ddahlnqederlmhgh")
    public suspend fun tier(`value`: Either<String, VCoreSkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("uiesgvwcfmmjulop")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VCoreSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("qybabulveceyxlhb")
    public fun tier(`value`: VCoreSkuTier) {
        val toBeMapped = Either.ofRight<String, VCoreSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): AutoScaleVCoreSkuArgs = AutoScaleVCoreSkuArgs(
        capacity = capacity,
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
