@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin.inputs

import com.pulumi.azurenative.powerbidedicated.inputs.SystemDataArgs.builder
import com.pulumi.azurenative.powerbidedicated.kotlin.enums.IdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Metadata pertaining to creation and last modification of the resource.
 * @property createdAt The timestamp of resource creation (UTC)
 * @property createdBy An identifier for the identity that created the resource
 * @property createdByType The type of identity that created the resource
 * @property lastModifiedAt The timestamp of resource last modification (UTC)
 * @property lastModifiedBy An identifier for the identity that last modified the resource
 * @property lastModifiedByType The type of identity that last modified the resource
 */
public data class SystemDataArgs(
    public val createdAt: Output<String>? = null,
    public val createdBy: Output<String>? = null,
    public val createdByType: Output<Either<String, IdentityType>>? = null,
    public val lastModifiedAt: Output<String>? = null,
    public val lastModifiedBy: Output<String>? = null,
    public val lastModifiedByType: Output<Either<String, IdentityType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerbidedicated.inputs.SystemDataArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbidedicated.inputs.SystemDataArgs =
        com.pulumi.azurenative.powerbidedicated.inputs.SystemDataArgs.builder()
            .createdAt(createdAt?.applyValue({ args0 -> args0 }))
            .createdBy(createdBy?.applyValue({ args0 -> args0 }))
            .createdByType(
                createdByType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .lastModifiedAt(lastModifiedAt?.applyValue({ args0 -> args0 }))
            .lastModifiedBy(lastModifiedBy?.applyValue({ args0 -> args0 }))
            .lastModifiedByType(
                lastModifiedByType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [SystemDataArgs].
 */
@PulumiTagMarker
public class SystemDataArgsBuilder internal constructor() {
    private var createdAt: Output<String>? = null

    private var createdBy: Output<String>? = null

    private var createdByType: Output<Either<String, IdentityType>>? = null

    private var lastModifiedAt: Output<String>? = null

    private var lastModifiedBy: Output<String>? = null

    private var lastModifiedByType: Output<Either<String, IdentityType>>? = null

    /**
     * @param value The timestamp of resource creation (UTC)
     */
    @JvmName("syyyokmixnhblpex")
    public suspend fun createdAt(`value`: Output<String>) {
        this.createdAt = value
    }

    /**
     * @param value An identifier for the identity that created the resource
     */
    @JvmName("ijwjspkgxopskacy")
    public suspend fun createdBy(`value`: Output<String>) {
        this.createdBy = value
    }

    /**
     * @param value The type of identity that created the resource
     */
    @JvmName("sgkfiqibthqwaeuo")
    public suspend fun createdByType(`value`: Output<Either<String, IdentityType>>) {
        this.createdByType = value
    }

    /**
     * @param value The timestamp of resource last modification (UTC)
     */
    @JvmName("txpfupvpjcxbwdte")
    public suspend fun lastModifiedAt(`value`: Output<String>) {
        this.lastModifiedAt = value
    }

    /**
     * @param value An identifier for the identity that last modified the resource
     */
    @JvmName("oxrkjmadohtfbqph")
    public suspend fun lastModifiedBy(`value`: Output<String>) {
        this.lastModifiedBy = value
    }

    /**
     * @param value The type of identity that last modified the resource
     */
    @JvmName("hefwtmcntohcpvtq")
    public suspend fun lastModifiedByType(`value`: Output<Either<String, IdentityType>>) {
        this.lastModifiedByType = value
    }

    /**
     * @param value The timestamp of resource creation (UTC)
     */
    @JvmName("eptntmomddsqggtt")
    public suspend fun createdAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdAt = mapped
    }

    /**
     * @param value An identifier for the identity that created the resource
     */
    @JvmName("blqxvjjyxfuwbrph")
    public suspend fun createdBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdBy = mapped
    }

    /**
     * @param value The type of identity that created the resource
     */
    @JvmName("vjjasgpewvlrrjxf")
    public suspend fun createdByType(`value`: Either<String, IdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdByType = mapped
    }

    /**
     * @param value The type of identity that created the resource
     */
    @JvmName("ekamneplilcwvgqo")
    public fun createdByType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createdByType = mapped
    }

    /**
     * @param value The type of identity that created the resource
     */
    @JvmName("jsegkufsxmxmtatd")
    public fun createdByType(`value`: IdentityType) {
        val toBeMapped = Either.ofRight<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createdByType = mapped
    }

    /**
     * @param value The timestamp of resource last modification (UTC)
     */
    @JvmName("tvvlsiyjvjjkuchw")
    public suspend fun lastModifiedAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedAt = mapped
    }

    /**
     * @param value An identifier for the identity that last modified the resource
     */
    @JvmName("trwetbrfeqstyigc")
    public suspend fun lastModifiedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedBy = mapped
    }

    /**
     * @param value The type of identity that last modified the resource
     */
    @JvmName("qfyjiuakjjiccxow")
    public suspend fun lastModifiedByType(`value`: Either<String, IdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedByType = mapped
    }

    /**
     * @param value The type of identity that last modified the resource
     */
    @JvmName("burvsteqdbrxfkut")
    public fun lastModifiedByType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lastModifiedByType = mapped
    }

    /**
     * @param value The type of identity that last modified the resource
     */
    @JvmName("aryiceeoocxdrmks")
    public fun lastModifiedByType(`value`: IdentityType) {
        val toBeMapped = Either.ofRight<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lastModifiedByType = mapped
    }

    internal fun build(): SystemDataArgs = SystemDataArgs(
        createdAt = createdAt,
        createdBy = createdBy,
        createdByType = createdByType,
        lastModifiedAt = lastModifiedAt,
        lastModifiedBy = lastModifiedBy,
        lastModifiedByType = lastModifiedByType,
    )
}
