@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.inputs

import com.pulumi.azurenative.powerplatform.inputs.EnterprisePolicyIdentityArgs.builder
import com.pulumi.azurenative.powerplatform.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The identity of the EnterprisePolicy.
 * @property type The type of identity used for the EnterprisePolicy. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
 */
public data class EnterprisePolicyIdentityArgs(
    public val type: Output<ResourceIdentityType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.inputs.EnterprisePolicyIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.inputs.EnterprisePolicyIdentityArgs =
        com.pulumi.azurenative.powerplatform.inputs.EnterprisePolicyIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EnterprisePolicyIdentityArgs].
 */
@PulumiTagMarker
public class EnterprisePolicyIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    /**
     * @param value The type of identity used for the EnterprisePolicy. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
     */
    @JvmName("icietbefmolmcusj")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The type of identity used for the EnterprisePolicy. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
     */
    @JvmName("bvmewwmvxjtsjyqq")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EnterprisePolicyIdentityArgs = EnterprisePolicyIdentityArgs(
        type = type,
    )
}
