@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.inputs

import com.pulumi.azurenative.powerplatform.inputs.GetEnterprisePolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enterprisePolicyName The EnterprisePolicy name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetEnterprisePolicyPlainArgs(
    public val enterprisePolicyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.inputs.GetEnterprisePolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.inputs.GetEnterprisePolicyPlainArgs =
        com.pulumi.azurenative.powerplatform.inputs.GetEnterprisePolicyPlainArgs.builder()
            .enterprisePolicyName(enterprisePolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnterprisePolicyPlainArgs].
 */
@PulumiTagMarker
public class GetEnterprisePolicyPlainArgsBuilder internal constructor() {
    private var enterprisePolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The EnterprisePolicy name.
     */
    @JvmName("qxhotqnljtejfqae")
    public suspend fun enterprisePolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.enterprisePolicyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("brphbxnjbxtormlq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEnterprisePolicyPlainArgs = GetEnterprisePolicyPlainArgs(
        enterprisePolicyName = enterprisePolicyName ?: throw
            PulumiNullFieldException("enterprisePolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
