@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.professionalservice.kotlin.inputs

import com.pulumi.azurenative.professionalservice.inputs.GetProfessionalServiceSubscriptionLevelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The name of the resource.
 * @property subscriptionId The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
 */
public data class GetProfessionalServiceSubscriptionLevelPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
    public val subscriptionId: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.professionalservice.inputs.GetProfessionalServiceSubscriptionLevelPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.professionalservice.inputs.GetProfessionalServiceSubscriptionLevelPlainArgs =
        com.pulumi.azurenative.professionalservice.inputs.GetProfessionalServiceSubscriptionLevelPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProfessionalServiceSubscriptionLevelPlainArgs].
 */
@PulumiTagMarker
public class GetProfessionalServiceSubscriptionLevelPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var subscriptionId: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("blbysgiwtiticwty")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("sahialptediabmdr")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
     */
    @JvmName("wvauxjtjsrjdogna")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    internal fun build(): GetProfessionalServiceSubscriptionLevelPlainArgs =
        GetProfessionalServiceSubscriptionLevelPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            subscriptionId = subscriptionId,
        )
}
