@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.professionalservice.kotlin.inputs

import com.pulumi.azurenative.professionalservice.inputs.ProfessionalServiceCreationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * properties for creation professionalService
 * @property autoRenew Whether the ProfessionalService subscription will auto renew upon term end.
 * @property billingPeriod The billing period eg P1M,P1Y for monthly,yearly respectively
 * @property offerId The offer id.
 * @property publisherId The publisher id.
 * @property quoteId The quote id which the ProfessionalService will be purchase with.
 * @property skuId The plan id.
 * @property storeFront The store front which initiates the purchase.
 * @property termUnit The unit term eg P1M,P1Y,P2Y,P3Y meaning month,1year,2year,3year respectively
 */
public data class ProfessionalServiceCreationPropertiesArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val billingPeriod: Output<String>? = null,
    public val offerId: Output<String>? = null,
    public val publisherId: Output<String>? = null,
    public val quoteId: Output<String>? = null,
    public val skuId: Output<String>? = null,
    public val storeFront: Output<String>? = null,
    public val termUnit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.professionalservice.inputs.ProfessionalServiceCreationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.professionalservice.inputs.ProfessionalServiceCreationPropertiesArgs =
        com.pulumi.azurenative.professionalservice.inputs.ProfessionalServiceCreationPropertiesArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .billingPeriod(billingPeriod?.applyValue({ args0 -> args0 }))
            .offerId(offerId?.applyValue({ args0 -> args0 }))
            .publisherId(publisherId?.applyValue({ args0 -> args0 }))
            .quoteId(quoteId?.applyValue({ args0 -> args0 }))
            .skuId(skuId?.applyValue({ args0 -> args0 }))
            .storeFront(storeFront?.applyValue({ args0 -> args0 }))
            .termUnit(termUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProfessionalServiceCreationPropertiesArgs].
 */
@PulumiTagMarker
public class ProfessionalServiceCreationPropertiesArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var billingPeriod: Output<String>? = null

    private var offerId: Output<String>? = null

    private var publisherId: Output<String>? = null

    private var quoteId: Output<String>? = null

    private var skuId: Output<String>? = null

    private var storeFront: Output<String>? = null

    private var termUnit: Output<String>? = null

    /**
     * @param value Whether the ProfessionalService subscription will auto renew upon term end.
     */
    @JvmName("ddrottfygansmihv")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The billing period eg P1M,P1Y for monthly,yearly respectively
     */
    @JvmName("akyvecemutmfevwb")
    public suspend fun billingPeriod(`value`: Output<String>) {
        this.billingPeriod = value
    }

    /**
     * @param value The offer id.
     */
    @JvmName("maexhxqwwsnuidtv")
    public suspend fun offerId(`value`: Output<String>) {
        this.offerId = value
    }

    /**
     * @param value The publisher id.
     */
    @JvmName("truyitdbwtnayryy")
    public suspend fun publisherId(`value`: Output<String>) {
        this.publisherId = value
    }

    /**
     * @param value The quote id which the ProfessionalService will be purchase with.
     */
    @JvmName("vbamugctacmmfpfq")
    public suspend fun quoteId(`value`: Output<String>) {
        this.quoteId = value
    }

    /**
     * @param value The plan id.
     */
    @JvmName("htoixftohafwsehp")
    public suspend fun skuId(`value`: Output<String>) {
        this.skuId = value
    }

    /**
     * @param value The store front which initiates the purchase.
     */
    @JvmName("nhlwytdtlptngpkw")
    public suspend fun storeFront(`value`: Output<String>) {
        this.storeFront = value
    }

    /**
     * @param value The unit term eg P1M,P1Y,P2Y,P3Y meaning month,1year,2year,3year respectively
     */
    @JvmName("yjqtjdnhkvxigphg")
    public suspend fun termUnit(`value`: Output<String>) {
        this.termUnit = value
    }

    /**
     * @param value Whether the ProfessionalService subscription will auto renew upon term end.
     */
    @JvmName("sgkwqqlvsxoucrqf")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The billing period eg P1M,P1Y for monthly,yearly respectively
     */
    @JvmName("stjuvnupvtqybsgn")
    public suspend fun billingPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingPeriod = mapped
    }

    /**
     * @param value The offer id.
     */
    @JvmName("aotqwnvuucgseepc")
    public suspend fun offerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offerId = mapped
    }

    /**
     * @param value The publisher id.
     */
    @JvmName("oyuivvjydljrpjvx")
    public suspend fun publisherId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherId = mapped
    }

    /**
     * @param value The quote id which the ProfessionalService will be purchase with.
     */
    @JvmName("chwfwicqtiowwwsm")
    public suspend fun quoteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quoteId = mapped
    }

    /**
     * @param value The plan id.
     */
    @JvmName("fbqmohfgqyafsnji")
    public suspend fun skuId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skuId = mapped
    }

    /**
     * @param value The store front which initiates the purchase.
     */
    @JvmName("oxnubllpqljojrvv")
    public suspend fun storeFront(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storeFront = mapped
    }

    /**
     * @param value The unit term eg P1M,P1Y,P2Y,P3Y meaning month,1year,2year,3year respectively
     */
    @JvmName("gqyyhtrqkxelbgdf")
    public suspend fun termUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.termUnit = mapped
    }

    internal fun build(): ProfessionalServiceCreationPropertiesArgs =
        ProfessionalServiceCreationPropertiesArgs(
            autoRenew = autoRenew,
            billingPeriod = billingPeriod,
            offerId = offerId,
            publisherId = publisherId,
            quoteId = quoteId,
            skuId = skuId,
            storeFront = storeFront,
            termUnit = termUnit,
        )
}
