@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.professionalservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The current Term object.
 * @property endDate The end date of the current term
 * @property startDate The start date of the current term
 * @property termUnit The unit term eg P1M,P1Y,P2Y,P3Y meaning month,1year,2year,3year respectively
 */
public data class ProfessionalServicePropertiesResponseTerm(
    public val endDate: String? = null,
    public val startDate: String? = null,
    public val termUnit: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.professionalservice.outputs.ProfessionalServicePropertiesResponseTerm):
            ProfessionalServicePropertiesResponseTerm = ProfessionalServicePropertiesResponseTerm(
            endDate = javaType.endDate().map({ args0 -> args0 }).orElse(null),
            startDate = javaType.startDate().map({ args0 -> args0 }).orElse(null),
            termUnit = javaType.termUnit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
