@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.ProviderRegistrationArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.inputs.ProviderRegistrationPropertiesArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.ProviderRegistrationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### ProviderRegistrations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerRegistration = new AzureNative.ProviderHub.ProviderRegistration("providerRegistration", new()
 *     {
 *         Properties = new AzureNative.ProviderHub.Inputs.ProviderRegistrationPropertiesArgs
 *         {
 *             Capabilities = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.ResourceProviderCapabilitiesArgs
 *                 {
 *                     Effect = "Allow",
 *                     QuotaId = "CSP_2015-05-01",
 *                 },
 *                 new AzureNative.ProviderHub.Inputs.ResourceProviderCapabilitiesArgs
 *                 {
 *                     Effect = "Allow",
 *                     QuotaId = "CSP_MG_2017-12-01",
 *                 },
 *             },
 *             Management = new AzureNative.ProviderHub.Inputs.ResourceProviderManifestPropertiesManagementArgs
 *             {
 *                 IncidentContactEmail = "helpme@contoso.com",
 *                 IncidentRoutingService = "Contoso Resource Provider",
 *                 IncidentRoutingTeam = "Contoso Triage",
 *                 ServiceTreeInfos = new[]
 *                 {
 *                     new AzureNative.ProviderHub.Inputs.ServiceTreeInfoArgs
 *                     {
 *                         ComponentId = "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69",
 *                         Readiness = "InDevelopment",
 *                         ServiceId = "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69",
 *                     },
 *                 },
 *             },
 *             ProviderType = "Internal",
 *             ProviderVersion = "2.0",
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := providerhub.NewProviderRegistration(ctx, "providerRegistration", &providerhub.ProviderRegistrationArgs{
 * Properties: providerhub.ProviderRegistrationResponseProperties{
 * Capabilities: providerhub.ResourceProviderCapabilitiesArray{
 * &providerhub.ResourceProviderCapabilitiesArgs{
 * Effect: pulumi.String("Allow"),
 * QuotaId: pulumi.String("CSP_2015-05-01"),
 * },
 * &providerhub.ResourceProviderCapabilitiesArgs{
 * Effect: pulumi.String("Allow"),
 * QuotaId: pulumi.String("CSP_MG_2017-12-01"),
 * },
 * },
 * Management: interface{}{
 * IncidentContactEmail: pulumi.String("helpme@contoso.com"),
 * IncidentRoutingService: pulumi.String("Contoso Resource Provider"),
 * IncidentRoutingTeam: pulumi.String("Contoso Triage"),
 * ServiceTreeInfos: providerhub.ServiceTreeInfoArray{
 * &providerhub.ServiceTreeInfoArgs{
 * ComponentId: pulumi.String("d1b7d8ba-05e2-48e6-90d6-d781b99c6e69"),
 * Readiness: pulumi.String("InDevelopment"),
 * ServiceId: pulumi.String("d1b7d8ba-05e2-48e6-90d6-d781b99c6e69"),
 * },
 * },
 * },
 * ProviderType: pulumi.String("Internal"),
 * ProviderVersion: pulumi.String("2.0"),
 * },
 * ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.ProviderRegistration;
 * import com.pulumi.azurenative.providerhub.ProviderRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerRegistration = new ProviderRegistration("providerRegistration", ProviderRegistrationArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("capabilities",
 *                     Map.ofEntries(
 *                         Map.entry("effect", "Allow"),
 *                         Map.entry("quotaId", "CSP_2015-05-01")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("effect", "Allow"),
 *                         Map.entry("quotaId", "CSP_MG_2017-12-01")
 *                     )),
 *                 Map.entry("management", Map.ofEntries(
 *                     Map.entry("incidentContactEmail", "helpme@contoso.com"),
 *                     Map.entry("incidentRoutingService", "Contoso Resource Provider"),
 *                     Map.entry("incidentRoutingTeam", "Contoso Triage"),
 *                     Map.entry("serviceTreeInfos", Map.ofEntries(
 *                         Map.entry("componentId", "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69"),
 *                         Map.entry("readiness", "InDevelopment"),
 *                         Map.entry("serviceId", "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69")
 *                     ))
 *                 )),
 *                 Map.entry("providerType", "Internal"),
 *                 Map.entry("providerVersion", "2.0")
 *             ))
 *             .providerNamespace("Microsoft.Contoso")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:ProviderRegistration myresource1 /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}
 * ```
 * @property properties
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 */
public data class ProviderRegistrationArgs(
    public val properties: Output<ProviderRegistrationPropertiesArgs>? = null,
    public val providerNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.ProviderRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.ProviderRegistrationArgs =
        com.pulumi.azurenative.providerhub.ProviderRegistrationArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerNamespace(providerNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderRegistrationArgs].
 */
@PulumiTagMarker
public class ProviderRegistrationArgsBuilder internal constructor() {
    private var properties: Output<ProviderRegistrationPropertiesArgs>? = null

    private var providerNamespace: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("frfdymfafupbnndl")
    public suspend fun properties(`value`: Output<ProviderRegistrationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("qgidswwypumqmwon")
    public suspend fun providerNamespace(`value`: Output<String>) {
        this.providerNamespace = value
    }

    /**
     * @param value
     */
    @JvmName("tbcctacocyugotpw")
    public suspend fun properties(`value`: ProviderRegistrationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xkbtkbblyfkcakyy")
    public suspend
    fun properties(argument: suspend ProviderRegistrationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderRegistrationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("teqrruafmnyutuoe")
    public suspend fun providerNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerNamespace = mapped
    }

    internal fun build(): ProviderRegistrationArgs = ProviderRegistrationArgs(
        properties = properties,
        providerNamespace = providerNamespace,
    )
}
