@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationResponseProperties
import com.pulumi.azurenative.providerhub.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationResponseProperties.Companion.toKotlin as resourceTypeRegistrationResponsePropertiesToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ResourceTypeRegistration].
 */
@PulumiTagMarker
public class ResourceTypeRegistrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceTypeRegistrationArgs = ResourceTypeRegistrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceTypeRegistrationArgsBuilder.() -> Unit) {
        val builder = ResourceTypeRegistrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResourceTypeRegistration {
        val builtJavaResource =
            com.pulumi.azurenative.providerhub.ResourceTypeRegistration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResourceTypeRegistration(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### ResourceTypeRegistrations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceTypeRegistration = new AzureNative.ProviderHub.ResourceTypeRegistration("resourceTypeRegistration", new()
 *     {
 *         Properties = new AzureNative.ProviderHub.Inputs.ResourceTypeRegistrationPropertiesArgs
 *         {
 *             Endpoints = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.ResourceTypeEndpointArgs
 *                 {
 *                     ApiVersions = new[]
 *                     {
 *                         "2020-06-01-preview",
 *                     },
 *                     Locations = new[]
 *                     {
 *                         "West US",
 *                         "East US",
 *                         "North Europe",
 *                     },
 *                     RequiredFeatures = new[]
 *                     {
 *                         "<feature flag>",
 *                     },
 *                 },
 *             },
 *             Management = new AzureNative.ProviderHub.Inputs.ResourceTypeRegistrationPropertiesManagementArgs
 *             {
 *                 IncidentContactEmail = "helpme@contoso.com",
 *                 IncidentRoutingService = "",
 *                 IncidentRoutingTeam = "",
 *                 ManifestOwners = new[]
 *                 {
 *                     "SPARTA-PlatformServiceAdministrator",
 *                 },
 *                 ResourceAccessPolicy = "NotSpecified",
 *                 ServiceTreeInfos = new[]
 *                 {
 *                     new AzureNative.ProviderHub.Inputs.ServiceTreeInfoArgs
 *                     {
 *                         ComponentId = "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69",
 *                         Readiness = "InDevelopment",
 *                         ServiceId = "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69",
 *                     },
 *                 },
 *             },
 *             OpenApiConfiguration = new AzureNative.ProviderHub.Inputs.OpenApiConfigurationArgs
 *             {
 *                 Validation = new AzureNative.ProviderHub.Inputs.OpenApiValidationArgs
 *                 {
 *                     AllowNoncompliantCollectionResponse = true,
 *                 },
 *             },
 *             Regionality = "Regional",
 *             ResourceConcurrencyControlOptions =
 *             {
 *                 { "patch", new AzureNative.ProviderHub.Inputs.ResourceConcurrencyControlOptionArgs
 *                 {
 *                     Policy = "SynchronizeBeginExtension",
 *                 } },
 *                 { "post", new AzureNative.ProviderHub.Inputs.ResourceConcurrencyControlOptionArgs
 *                 {
 *                     Policy = "SynchronizeBeginExtension",
 *                 } },
 *                 { "put", new AzureNative.ProviderHub.Inputs.ResourceConcurrencyControlOptionArgs
 *                 {
 *                     Policy = "SynchronizeBeginExtension",
 *                 } },
 *             },
 *             ResourceGraphConfiguration = new AzureNative.ProviderHub.Inputs.ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs
 *             {
 *                 ApiVersion = "2019-01-01",
 *                 Enabled = true,
 *             },
 *             RoutingType = "Default",
 *             SwaggerSpecifications = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.SwaggerSpecificationArgs
 *                 {
 *                     ApiVersions = new[]
 *                     {
 *                         "2020-06-01-preview",
 *                     },
 *                     SwaggerSpecFolderUri = "https://github.com/Azure/azure-rest-api-specs/blob/feature/azure/contoso/specification/contoso/resource-manager/Microsoft.SampleRP/",
 *                 },
 *             },
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *         ResourceType = "employees",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := providerhub.NewResourceTypeRegistration(ctx, "resourceTypeRegistration", &providerhub.ResourceTypeRegistrationArgs{
 * Properties: providerhub.ResourceTypeRegistrationResponseProperties{
 * Endpoints: providerhub.ResourceTypeEndpointArray{
 * &providerhub.ResourceTypeEndpointArgs{
 * ApiVersions: pulumi.StringArray{
 * pulumi.String("2020-06-01-preview"),
 * },
 * Locations: pulumi.StringArray{
 * pulumi.String("West US"),
 * pulumi.String("East US"),
 * pulumi.String("North Europe"),
 * },
 * RequiredFeatures: pulumi.StringArray{
 * pulumi.String("<feature flag>"),
 * },
 * },
 * },
 * Management: interface{}{
 * IncidentContactEmail: pulumi.String("helpme@contoso.com"),
 * IncidentRoutingService: pulumi.String(""),
 * IncidentRoutingTeam: pulumi.String(""),
 * ManifestOwners: pulumi.StringArray{
 * pulumi.String("SPARTA-PlatformServiceAdministrator"),
 * },
 * ResourceAccessPolicy: pulumi.String("NotSpecified"),
 * ServiceTreeInfos: providerhub.ServiceTreeInfoArray{
 * &providerhub.ServiceTreeInfoArgs{
 * ComponentId: pulumi.String("d1b7d8ba-05e2-48e6-90d6-d781b99c6e69"),
 * Readiness: pulumi.String("InDevelopment"),
 * ServiceId: pulumi.String("d1b7d8ba-05e2-48e6-90d6-d781b99c6e69"),
 * },
 * },
 * },
 * OpenApiConfiguration: interface{}{
 * Validation: &providerhub.OpenApiValidationArgs{
 * AllowNoncompliantCollectionResponse: pulumi.Bool(true),
 * },
 * },
 * Regionality: pulumi.String("Regional"),
 * ResourceConcurrencyControlOptions: providerhub.ResourceConcurrencyControlOptionMap{
 * "patch": &providerhub.ResourceConcurrencyControlOptionArgs{
 * Policy: pulumi.String("SynchronizeBeginExtension"),
 * },
 * "post": &providerhub.ResourceConcurrencyControlOptionArgs{
 * Policy: pulumi.String("SynchronizeBeginExtension"),
 * },
 * "put": &providerhub.ResourceConcurrencyControlOptionArgs{
 * Policy: pulumi.String("SynchronizeBeginExtension"),
 * },
 * },
 * ResourceGraphConfiguration: &providerhub.ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs{
 * ApiVersion: pulumi.String("2019-01-01"),
 * Enabled: pulumi.Bool(true),
 * },
 * RoutingType: pulumi.String("Default"),
 * SwaggerSpecifications: providerhub.SwaggerSpecificationArray{
 * &providerhub.SwaggerSpecificationArgs{
 * ApiVersions: pulumi.StringArray{
 * pulumi.String("2020-06-01-preview"),
 * },
 * SwaggerSpecFolderUri: pulumi.String("https://github.com/Azure/azure-rest-api-specs/blob/feature/azure/contoso/specification/contoso/resource-manager/Microsoft.SampleRP/"),
 * },
 * },
 * },
 * ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * ResourceType: pulumi.String("employees"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.ResourceTypeRegistration;
 * import com.pulumi.azurenative.providerhub.ResourceTypeRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceTypeRegistration = new ResourceTypeRegistration("resourceTypeRegistration", ResourceTypeRegistrationArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("endpoints", Map.ofEntries(
 *                     Map.entry("apiVersions", "2020-06-01-preview"),
 *                     Map.entry("locations",
 *                         "West US",
 *                         "East US",
 *                         "North Europe"),
 *                     Map.entry("requiredFeatures", "<feature flag>")
 *                 )),
 *                 Map.entry("management", Map.ofEntries(
 *                     Map.entry("incidentContactEmail", "helpme@contoso.com"),
 *                     Map.entry("incidentRoutingService", ""),
 *                     Map.entry("incidentRoutingTeam", ""),
 *                     Map.entry("manifestOwners", "SPARTA-PlatformServiceAdministrator"),
 *                     Map.entry("resourceAccessPolicy", "NotSpecified"),
 *                     Map.entry("serviceTreeInfos", Map.ofEntries(
 *                         Map.entry("componentId", "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69"),
 *                         Map.entry("readiness", "InDevelopment"),
 *                         Map.entry("serviceId", "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69")
 *                     ))
 *                 )),
 *                 Map.entry("openApiConfiguration", Map.of("validation", Map.of("allowNoncompliantCollectionResponse", true))),
 *                 Map.entry("regionality", "Regional"),
 *                 Map.entry("resourceConcurrencyControlOptions", Map.ofEntries(
 *                     Map.entry("patch", Map.of("policy", "SynchronizeBeginExtension")),
 *                     Map.entry("post", Map.of("policy", "SynchronizeBeginExtension")),
 *                     Map.entry("put", Map.of("policy", "SynchronizeBeginExtension"))
 *                 )),
 *                 Map.entry("resourceGraphConfiguration", Map.ofEntries(
 *                     Map.entry("apiVersion", "2019-01-01"),
 *                     Map.entry("enabled", true)
 *                 )),
 *                 Map.entry("routingType", "Default"),
 *                 Map.entry("swaggerSpecifications", Map.ofEntries(
 *                     Map.entry("apiVersions", "2020-06-01-preview"),
 *                     Map.entry("swaggerSpecFolderUri", "https://github.com/Azure/azure-rest-api-specs/blob/feature/azure/contoso/specification/contoso/resource-manager/Microsoft.SampleRP/")
 *                 ))
 *             ))
 *             .providerNamespace("Microsoft.Contoso")
 *             .resourceType("employees")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:ResourceTypeRegistration employees /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}
 * ```
 */
public class ResourceTypeRegistration internal constructor(
    override val javaResource: com.pulumi.azurenative.providerhub.ResourceTypeRegistration,
) : KotlinCustomResource(javaResource, ResourceTypeRegistrationMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<ResourceTypeRegistrationResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceTypeRegistrationResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ResourceTypeRegistrationMapper : ResourceMapper<ResourceTypeRegistration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.providerhub.ResourceTypeRegistration::class == javaResource::class

    override fun map(javaResource: Resource): ResourceTypeRegistration =
        ResourceTypeRegistration(
            javaResource as
                com.pulumi.azurenative.providerhub.ResourceTypeRegistration,
        )
}

/**
 * @see [ResourceTypeRegistration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceTypeRegistration].
 */
public suspend fun resourceTypeRegistration(
    name: String,
    block: suspend ResourceTypeRegistrationResourceBuilder.() -> Unit,
): ResourceTypeRegistration {
    val builder = ResourceTypeRegistrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceTypeRegistration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceTypeRegistration(name: String): ResourceTypeRegistration {
    val builder = ResourceTypeRegistrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
