@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.LightHouseAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property principalId
 * @property roleDefinitionId
 */
public data class LightHouseAuthorizationArgs(
    public val principalId: Output<String>,
    public val roleDefinitionId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.LightHouseAuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.LightHouseAuthorizationArgs =
        com.pulumi.azurenative.providerhub.inputs.LightHouseAuthorizationArgs.builder()
            .principalId(principalId.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LightHouseAuthorizationArgs].
 */
@PulumiTagMarker
public class LightHouseAuthorizationArgsBuilder internal constructor() {
    private var principalId: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("glhejmbdskgvuvpo")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value
     */
    @JvmName("haytapkobvvcpfmb")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value
     */
    @JvmName("wumutwjjkumxchen")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value
     */
    @JvmName("wldhfyytqvakjbwf")
    public suspend fun roleDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    internal fun build(): LightHouseAuthorizationArgs = LightHouseAuthorizationArgs(
        principalId = principalId ?: throw PulumiNullFieldException("principalId"),
        roleDefinitionId = roleDefinitionId ?: throw PulumiNullFieldException("roleDefinitionId"),
    )
}
