@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceProviderAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationId
 * @property managedByRoleDefinitionId
 * @property roleDefinitionId
 */
public data class ResourceProviderAuthorizationArgs(
    public val applicationId: Output<String>? = null,
    public val managedByRoleDefinitionId: Output<String>? = null,
    public val roleDefinitionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceProviderAuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ResourceProviderAuthorizationArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceProviderAuthorizationArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .managedByRoleDefinitionId(managedByRoleDefinitionId?.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceProviderAuthorizationArgs].
 */
@PulumiTagMarker
public class ResourceProviderAuthorizationArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var managedByRoleDefinitionId: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ifdvvcdmdanduvbi")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value
     */
    @JvmName("qlqteisgmdqmcucv")
    public suspend fun managedByRoleDefinitionId(`value`: Output<String>) {
        this.managedByRoleDefinitionId = value
    }

    /**
     * @param value
     */
    @JvmName("sjuftdfoouppirnr")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value
     */
    @JvmName("jiqsnosplnytpwox")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value
     */
    @JvmName("tequxhafoqcgedyf")
    public suspend fun managedByRoleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedByRoleDefinitionId = mapped
    }

    /**
     * @param value
     */
    @JvmName("whnwuaapxwqjdvna")
    public suspend fun roleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    internal fun build(): ResourceProviderAuthorizationArgs = ResourceProviderAuthorizationArgs(
        applicationId = applicationId,
        managedByRoleDefinitionId = managedByRoleDefinitionId,
        roleDefinitionId = roleDefinitionId,
    )
}
