@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.providerhub.kotlin.enums.Regionality
import com.pulumi.azurenative.providerhub.kotlin.enums.ResourceDeletionPolicy
import com.pulumi.azurenative.providerhub.kotlin.enums.RoutingType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property allowedUnauthorizedActions
 * @property authorizationActionMappings
 * @property checkNameAvailabilitySpecifications
 * @property defaultApiVersion
 * @property disallowedActionVerbs
 * @property enableAsyncOperation
 * @property enableThirdPartyS2S
 * @property endpoints
 * @property extendedLocations
 * @property extensionOptions
 * @property featuresRule
 * @property identityManagement
 * @property isPureProxy
 * @property linkedAccessChecks
 * @property loggingRules
 * @property management
 * @property marketplaceType
 * @property openApiConfiguration
 * @property provisioningState The provisioned state of the resource.
 * @property regionality
 * @property requestHeaderOptions
 * @property requiredFeatures
 * @property resourceConcurrencyControlOptions
 * @property resourceDeletionPolicy
 * @property resourceGraphConfiguration
 * @property resourceMovePolicy
 * @property routingType
 * @property serviceTreeInfos
 * @property subscriptionLifecycleNotificationSpecifications
 * @property subscriptionStateRules
 * @property swaggerSpecifications
 * @property templateDeploymentOptions
 * @property throttlingRules
 */
public data class ResourceTypeRegistrationPropertiesArgs(
    public val allowedUnauthorizedActions: Output<List<String>>? = null,
    public val authorizationActionMappings: Output<List<AuthorizationActionMappingArgs>>? = null,
    public val checkNameAvailabilitySpecifications:
    Output<ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs>? = null,
    public val defaultApiVersion: Output<String>? = null,
    public val disallowedActionVerbs: Output<List<String>>? = null,
    public val enableAsyncOperation: Output<Boolean>? = null,
    public val enableThirdPartyS2S: Output<Boolean>? = null,
    public val endpoints: Output<List<ResourceTypeEndpointArgs>>? = null,
    public val extendedLocations: Output<List<ExtendedLocationOptionsArgs>>? = null,
    public val extensionOptions: Output<ResourceTypeRegistrationPropertiesExtensionOptionsArgs>? =
        null,
    public val featuresRule: Output<ResourceTypeRegistrationPropertiesFeaturesRuleArgs>? = null,
    public val identityManagement: Output<ResourceTypeRegistrationPropertiesIdentityManagementArgs>? =
        null,
    public val isPureProxy: Output<Boolean>? = null,
    public val linkedAccessChecks: Output<List<LinkedAccessCheckArgs>>? = null,
    public val loggingRules: Output<List<LoggingRuleArgs>>? = null,
    public val management: Output<ResourceTypeRegistrationPropertiesManagementArgs>? = null,
    public val marketplaceType: Output<String>? = null,
    public val openApiConfiguration: Output<OpenApiConfigurationArgs>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val regionality: Output<Either<String, Regionality>>? = null,
    public val requestHeaderOptions:
    Output<ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs>? = null,
    public val requiredFeatures: Output<List<String>>? = null,
    public val resourceConcurrencyControlOptions:
    Output<Map<String, ResourceConcurrencyControlOptionArgs>>? = null,
    public val resourceDeletionPolicy: Output<Either<String, ResourceDeletionPolicy>>? = null,
    public val resourceGraphConfiguration:
    Output<ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs>? = null,
    public val resourceMovePolicy: Output<ResourceTypeRegistrationPropertiesResourceMovePolicyArgs>? =
        null,
    public val routingType: Output<Either<String, RoutingType>>? = null,
    public val serviceTreeInfos: Output<List<ServiceTreeInfoArgs>>? = null,
    public val subscriptionLifecycleNotificationSpecifications:
    Output<ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs>? =
        null,
    public val subscriptionStateRules: Output<List<SubscriptionStateRuleArgs>>? = null,
    public val swaggerSpecifications: Output<List<SwaggerSpecificationArgs>>? = null,
    public val templateDeploymentOptions:
    Output<ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs>? = null,
    public val throttlingRules: Output<List<ThrottlingRuleArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesArgs.builder()
            .allowedUnauthorizedActions(
                allowedUnauthorizedActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .authorizationActionMappings(
                authorizationActionMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .checkNameAvailabilitySpecifications(
                checkNameAvailabilitySpecifications?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .defaultApiVersion(defaultApiVersion?.applyValue({ args0 -> args0 }))
            .disallowedActionVerbs(disallowedActionVerbs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enableAsyncOperation(enableAsyncOperation?.applyValue({ args0 -> args0 }))
            .enableThirdPartyS2S(enableThirdPartyS2S?.applyValue({ args0 -> args0 }))
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .extendedLocations(
                extendedLocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .extensionOptions(extensionOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .featuresRule(featuresRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identityManagement(
                identityManagement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isPureProxy(isPureProxy?.applyValue({ args0 -> args0 }))
            .linkedAccessChecks(
                linkedAccessChecks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .loggingRules(
                loggingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .management(management?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .marketplaceType(marketplaceType?.applyValue({ args0 -> args0 }))
            .openApiConfiguration(
                openApiConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .regionality(
                regionality?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .requestHeaderOptions(
                requestHeaderOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .requiredFeatures(requiredFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceConcurrencyControlOptions(
                resourceConcurrencyControlOptions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value.let({ args0 -> args0.toJava() })) }).toMap()
                }),
            )
            .resourceDeletionPolicy(
                resourceDeletionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGraphConfiguration(
                resourceGraphConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceMovePolicy(
                resourceMovePolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .routingType(
                routingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceTreeInfos(
                serviceTreeInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subscriptionLifecycleNotificationSpecifications(
                subscriptionLifecycleNotificationSpecifications?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .subscriptionStateRules(
                subscriptionStateRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .swaggerSpecifications(
                swaggerSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .templateDeploymentOptions(
                templateDeploymentOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .throttlingRules(
                throttlingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceTypeRegistrationPropertiesArgs].
 */
@PulumiTagMarker
public class ResourceTypeRegistrationPropertiesArgsBuilder internal constructor() {
    private var allowedUnauthorizedActions: Output<List<String>>? = null

    private var authorizationActionMappings: Output<List<AuthorizationActionMappingArgs>>? = null

    private var checkNameAvailabilitySpecifications:
        Output<ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs>? = null

    private var defaultApiVersion: Output<String>? = null

    private var disallowedActionVerbs: Output<List<String>>? = null

    private var enableAsyncOperation: Output<Boolean>? = null

    private var enableThirdPartyS2S: Output<Boolean>? = null

    private var endpoints: Output<List<ResourceTypeEndpointArgs>>? = null

    private var extendedLocations: Output<List<ExtendedLocationOptionsArgs>>? = null

    private var extensionOptions: Output<ResourceTypeRegistrationPropertiesExtensionOptionsArgs>? =
        null

    private var featuresRule: Output<ResourceTypeRegistrationPropertiesFeaturesRuleArgs>? = null

    private var identityManagement: Output<ResourceTypeRegistrationPropertiesIdentityManagementArgs>? =
        null

    private var isPureProxy: Output<Boolean>? = null

    private var linkedAccessChecks: Output<List<LinkedAccessCheckArgs>>? = null

    private var loggingRules: Output<List<LoggingRuleArgs>>? = null

    private var management: Output<ResourceTypeRegistrationPropertiesManagementArgs>? = null

    private var marketplaceType: Output<String>? = null

    private var openApiConfiguration: Output<OpenApiConfigurationArgs>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var regionality: Output<Either<String, Regionality>>? = null

    private var requestHeaderOptions:
        Output<ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs>? = null

    private var requiredFeatures: Output<List<String>>? = null

    private var resourceConcurrencyControlOptions:
        Output<Map<String, ResourceConcurrencyControlOptionArgs>>? = null

    private var resourceDeletionPolicy: Output<Either<String, ResourceDeletionPolicy>>? = null

    private var resourceGraphConfiguration:
        Output<ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs>? = null

    private var resourceMovePolicy: Output<ResourceTypeRegistrationPropertiesResourceMovePolicyArgs>? =
        null

    private var routingType: Output<Either<String, RoutingType>>? = null

    private var serviceTreeInfos: Output<List<ServiceTreeInfoArgs>>? = null

    private var subscriptionLifecycleNotificationSpecifications:
        Output<ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs>? =
        null

    private var subscriptionStateRules: Output<List<SubscriptionStateRuleArgs>>? = null

    private var swaggerSpecifications: Output<List<SwaggerSpecificationArgs>>? = null

    private var templateDeploymentOptions:
        Output<ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs>? = null

    private var throttlingRules: Output<List<ThrottlingRuleArgs>>? = null

    /**
     * @param value
     */
    @JvmName("dskrevnipevehrqe")
    public suspend fun allowedUnauthorizedActions(`value`: Output<List<String>>) {
        this.allowedUnauthorizedActions = value
    }

    @JvmName("mskmcbenhlwibtwh")
    public suspend fun allowedUnauthorizedActions(vararg values: Output<String>) {
        this.allowedUnauthorizedActions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("swcioejnkashjlnb")
    public suspend fun allowedUnauthorizedActions(values: List<Output<String>>) {
        this.allowedUnauthorizedActions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("aanxdvpcqvlrgfut")
    public suspend
    fun authorizationActionMappings(`value`: Output<List<AuthorizationActionMappingArgs>>) {
        this.authorizationActionMappings = value
    }

    @JvmName("hkuemplruescoujo")
    public suspend fun authorizationActionMappings(
        vararg
        values: Output<AuthorizationActionMappingArgs>,
    ) {
        this.authorizationActionMappings = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("edlwxsgceevtcphn")
    public suspend
    fun authorizationActionMappings(values: List<Output<AuthorizationActionMappingArgs>>) {
        this.authorizationActionMappings = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xgtlnlxbvljorqiu")
    public suspend
    fun checkNameAvailabilitySpecifications(`value`: Output<ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs>) {
        this.checkNameAvailabilitySpecifications = value
    }

    /**
     * @param value
     */
    @JvmName("rofqwwmioafaavwq")
    public suspend fun defaultApiVersion(`value`: Output<String>) {
        this.defaultApiVersion = value
    }

    /**
     * @param value
     */
    @JvmName("rtyuatnyeqnlrcaa")
    public suspend fun disallowedActionVerbs(`value`: Output<List<String>>) {
        this.disallowedActionVerbs = value
    }

    @JvmName("acuciuudrkxtglxa")
    public suspend fun disallowedActionVerbs(vararg values: Output<String>) {
        this.disallowedActionVerbs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("qilbdmmgbgxesgpg")
    public suspend fun disallowedActionVerbs(values: List<Output<String>>) {
        this.disallowedActionVerbs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("mhjhfkpsoktlqfdd")
    public suspend fun enableAsyncOperation(`value`: Output<Boolean>) {
        this.enableAsyncOperation = value
    }

    /**
     * @param value
     */
    @JvmName("qsiaycmaidbuncmr")
    public suspend fun enableThirdPartyS2S(`value`: Output<Boolean>) {
        this.enableThirdPartyS2S = value
    }

    /**
     * @param value
     */
    @JvmName("fxfjsybypbejyxma")
    public suspend fun endpoints(`value`: Output<List<ResourceTypeEndpointArgs>>) {
        this.endpoints = value
    }

    @JvmName("dienmiqarubgkkwg")
    public suspend fun endpoints(vararg values: Output<ResourceTypeEndpointArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fragfonjnetwkevq")
    public suspend fun endpoints(values: List<Output<ResourceTypeEndpointArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("iksdxjhsawyrwvcw")
    public suspend fun extendedLocations(`value`: Output<List<ExtendedLocationOptionsArgs>>) {
        this.extendedLocations = value
    }

    @JvmName("ajoyylhtwmletdfn")
    public suspend fun extendedLocations(vararg values: Output<ExtendedLocationOptionsArgs>) {
        this.extendedLocations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("urnfpbsdbnhgtrtw")
    public suspend fun extendedLocations(values: List<Output<ExtendedLocationOptionsArgs>>) {
        this.extendedLocations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("cxqcuodycnxudjke")
    public suspend
    fun extensionOptions(`value`: Output<ResourceTypeRegistrationPropertiesExtensionOptionsArgs>) {
        this.extensionOptions = value
    }

    /**
     * @param value
     */
    @JvmName("pnfyxdsufnemciph")
    public suspend
    fun featuresRule(`value`: Output<ResourceTypeRegistrationPropertiesFeaturesRuleArgs>) {
        this.featuresRule = value
    }

    /**
     * @param value
     */
    @JvmName("jgldagswqnxtferr")
    public suspend
    fun identityManagement(`value`: Output<ResourceTypeRegistrationPropertiesIdentityManagementArgs>) {
        this.identityManagement = value
    }

    /**
     * @param value
     */
    @JvmName("mroarceqqxcyrknm")
    public suspend fun isPureProxy(`value`: Output<Boolean>) {
        this.isPureProxy = value
    }

    /**
     * @param value
     */
    @JvmName("fdbrryctandmaemc")
    public suspend fun linkedAccessChecks(`value`: Output<List<LinkedAccessCheckArgs>>) {
        this.linkedAccessChecks = value
    }

    @JvmName("nspfabxnmngbkdxc")
    public suspend fun linkedAccessChecks(vararg values: Output<LinkedAccessCheckArgs>) {
        this.linkedAccessChecks = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("hhfefnmgqykvjpvu")
    public suspend fun linkedAccessChecks(values: List<Output<LinkedAccessCheckArgs>>) {
        this.linkedAccessChecks = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kjvqcusbhynddgnr")
    public suspend fun loggingRules(`value`: Output<List<LoggingRuleArgs>>) {
        this.loggingRules = value
    }

    @JvmName("tnkqlnshfoyfbyqn")
    public suspend fun loggingRules(vararg values: Output<LoggingRuleArgs>) {
        this.loggingRules = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vyqjvfmvxwwbpkhi")
    public suspend fun loggingRules(values: List<Output<LoggingRuleArgs>>) {
        this.loggingRules = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ywuarcqwrxsvhbpy")
    public suspend fun management(`value`: Output<ResourceTypeRegistrationPropertiesManagementArgs>) {
        this.management = value
    }

    /**
     * @param value
     */
    @JvmName("jylvroweargssack")
    public suspend fun marketplaceType(`value`: Output<String>) {
        this.marketplaceType = value
    }

    /**
     * @param value
     */
    @JvmName("niedpwsxemdixaxc")
    public suspend fun openApiConfiguration(`value`: Output<OpenApiConfigurationArgs>) {
        this.openApiConfiguration = value
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("gbjgmagivekfegor")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value
     */
    @JvmName("mhjwytcnhyxfxdgr")
    public suspend fun regionality(`value`: Output<Either<String, Regionality>>) {
        this.regionality = value
    }

    /**
     * @param value
     */
    @JvmName("lssytsqxgcdbpjbx")
    public suspend
    fun requestHeaderOptions(`value`: Output<ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs>) {
        this.requestHeaderOptions = value
    }

    /**
     * @param value
     */
    @JvmName("raeniqqayjgktxkw")
    public suspend fun requiredFeatures(`value`: Output<List<String>>) {
        this.requiredFeatures = value
    }

    @JvmName("lawuiungamuvxfoa")
    public suspend fun requiredFeatures(vararg values: Output<String>) {
        this.requiredFeatures = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("pcxmkkmlwnkttqdi")
    public suspend fun requiredFeatures(values: List<Output<String>>) {
        this.requiredFeatures = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("lymkuuyjbudmywnn")
    public suspend
    fun resourceConcurrencyControlOptions(`value`: Output<Map<String, ResourceConcurrencyControlOptionArgs>>) {
        this.resourceConcurrencyControlOptions = value
    }

    /**
     * @param value
     */
    @JvmName("trpbbkwwjxxxpvoi")
    public suspend
    fun resourceDeletionPolicy(`value`: Output<Either<String, ResourceDeletionPolicy>>) {
        this.resourceDeletionPolicy = value
    }

    /**
     * @param value
     */
    @JvmName("jndniloxbwgiphaw")
    public suspend
    fun resourceGraphConfiguration(`value`: Output<ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs>) {
        this.resourceGraphConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("xcdnynpxbniamfqa")
    public suspend
    fun resourceMovePolicy(`value`: Output<ResourceTypeRegistrationPropertiesResourceMovePolicyArgs>) {
        this.resourceMovePolicy = value
    }

    /**
     * @param value
     */
    @JvmName("xpynlhlnufkvlsuk")
    public suspend fun routingType(`value`: Output<Either<String, RoutingType>>) {
        this.routingType = value
    }

    /**
     * @param value
     */
    @JvmName("tfkavnliwqjxqoys")
    public suspend fun serviceTreeInfos(`value`: Output<List<ServiceTreeInfoArgs>>) {
        this.serviceTreeInfos = value
    }

    @JvmName("lisljahejgiljuym")
    public suspend fun serviceTreeInfos(vararg values: Output<ServiceTreeInfoArgs>) {
        this.serviceTreeInfos = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("eylejiskilknmyor")
    public suspend fun serviceTreeInfos(values: List<Output<ServiceTreeInfoArgs>>) {
        this.serviceTreeInfos = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("unxoqtjdopbduinp")
    public suspend
    fun subscriptionLifecycleNotificationSpecifications(`value`: Output<ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs>) {
        this.subscriptionLifecycleNotificationSpecifications = value
    }

    /**
     * @param value
     */
    @JvmName("ppkbcxbgsotnojjb")
    public suspend fun subscriptionStateRules(`value`: Output<List<SubscriptionStateRuleArgs>>) {
        this.subscriptionStateRules = value
    }

    @JvmName("anbmbxmmwistkgql")
    public suspend fun subscriptionStateRules(vararg values: Output<SubscriptionStateRuleArgs>) {
        this.subscriptionStateRules = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("tqeidcyndulrbyoq")
    public suspend fun subscriptionStateRules(values: List<Output<SubscriptionStateRuleArgs>>) {
        this.subscriptionStateRules = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("lqgnhmopfddahxqx")
    public suspend fun swaggerSpecifications(`value`: Output<List<SwaggerSpecificationArgs>>) {
        this.swaggerSpecifications = value
    }

    @JvmName("pysbadojlnnsrfyt")
    public suspend fun swaggerSpecifications(vararg values: Output<SwaggerSpecificationArgs>) {
        this.swaggerSpecifications = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("kdhpugxyeqswfhmy")
    public suspend fun swaggerSpecifications(values: List<Output<SwaggerSpecificationArgs>>) {
        this.swaggerSpecifications = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("tvqsjtvkcvbwripj")
    public suspend
    fun templateDeploymentOptions(`value`: Output<ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs>) {
        this.templateDeploymentOptions = value
    }

    /**
     * @param value
     */
    @JvmName("ygxqtwqgvdmpjguy")
    public suspend fun throttlingRules(`value`: Output<List<ThrottlingRuleArgs>>) {
        this.throttlingRules = value
    }

    @JvmName("gsibkfmhsavyxxcb")
    public suspend fun throttlingRules(vararg values: Output<ThrottlingRuleArgs>) {
        this.throttlingRules = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("utkopatfliisvgrb")
    public suspend fun throttlingRules(values: List<Output<ThrottlingRuleArgs>>) {
        this.throttlingRules = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("esekaqfaoqghrusj")
    public suspend fun allowedUnauthorizedActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedUnauthorizedActions = mapped
    }

    /**
     * @param values
     */
    @JvmName("limkdgxerhhdqnyw")
    public suspend fun allowedUnauthorizedActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedUnauthorizedActions = mapped
    }

    /**
     * @param value
     */
    @JvmName("cexpqkxdrsevxtva")
    public suspend fun authorizationActionMappings(`value`: List<AuthorizationActionMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationActionMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ysdaddunhoutwftm")
    public suspend
    fun authorizationActionMappings(argument: List<suspend AuthorizationActionMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AuthorizationActionMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizationActionMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ebheblcelsvwhthp")
    public suspend fun authorizationActionMappings(
        vararg
        argument: suspend AuthorizationActionMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AuthorizationActionMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizationActionMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lklvrearykjwyftt")
    public suspend
    fun authorizationActionMappings(argument: suspend AuthorizationActionMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AuthorizationActionMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authorizationActionMappings = mapped
    }

    /**
     * @param values
     */
    @JvmName("cqcxckixfymvqobr")
    public suspend fun authorizationActionMappings(vararg values: AuthorizationActionMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationActionMappings = mapped
    }

    /**
     * @param value
     */
    @JvmName("updfmlwiptewjrks")
    public suspend
    fun checkNameAvailabilitySpecifications(`value`: ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkNameAvailabilitySpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("shrfryhspbbdpfgc")
    public suspend
    fun checkNameAvailabilitySpecifications(argument: suspend ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.checkNameAvailabilitySpecifications = mapped
    }

    /**
     * @param value
     */
    @JvmName("cmydpiyljgckncku")
    public suspend fun defaultApiVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultApiVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("nbvpdyyfejslclcq")
    public suspend fun disallowedActionVerbs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disallowedActionVerbs = mapped
    }

    /**
     * @param values
     */
    @JvmName("gibpdbukjglaoduj")
    public suspend fun disallowedActionVerbs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disallowedActionVerbs = mapped
    }

    /**
     * @param value
     */
    @JvmName("qkveycayhovuufiu")
    public suspend fun enableAsyncOperation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAsyncOperation = mapped
    }

    /**
     * @param value
     */
    @JvmName("fidaorqdtjdwcvbu")
    public suspend fun enableThirdPartyS2S(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableThirdPartyS2S = mapped
    }

    /**
     * @param value
     */
    @JvmName("xwiaotebpdujaekr")
    public suspend fun endpoints(`value`: List<ResourceTypeEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tfhhjrfmergvdtis")
    public suspend fun endpoints(argument: List<suspend ResourceTypeEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceTypeEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yttwpbxnylwtghjy")
    public suspend fun endpoints(
        vararg
        argument: suspend ResourceTypeEndpointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceTypeEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uuxthmufdulifcjd")
    public suspend fun endpoints(argument: suspend ResourceTypeEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceTypeEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values
     */
    @JvmName("wsbiekaprawkarri")
    public suspend fun endpoints(vararg values: ResourceTypeEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value
     */
    @JvmName("fljctwbtirmaiqyj")
    public suspend fun extendedLocations(`value`: List<ExtendedLocationOptionsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hoxxsewxhbpmuvat")
    public suspend
    fun extendedLocations(argument: List<suspend ExtendedLocationOptionsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExtendedLocationOptionsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extendedLocations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("chhdtxhktbsclloa")
    public suspend fun extendedLocations(
        vararg
        argument: suspend ExtendedLocationOptionsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExtendedLocationOptionsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extendedLocations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ktbtoskhkryletsi")
    public suspend
    fun extendedLocations(argument: suspend ExtendedLocationOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExtendedLocationOptionsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.extendedLocations = mapped
    }

    /**
     * @param values
     */
    @JvmName("cmbckpgrniaosvdq")
    public suspend fun extendedLocations(vararg values: ExtendedLocationOptionsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extendedLocations = mapped
    }

    /**
     * @param value
     */
    @JvmName("bvssfbrqfpucnprt")
    public suspend
    fun extensionOptions(`value`: ResourceTypeRegistrationPropertiesExtensionOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("iwkjxgnysmsqwrgg")
    public suspend
    fun extensionOptions(argument: suspend ResourceTypeRegistrationPropertiesExtensionOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesExtensionOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extensionOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("vbemlsuancjqiqqg")
    public suspend fun featuresRule(`value`: ResourceTypeRegistrationPropertiesFeaturesRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featuresRule = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ewactdcjxbtjhwlv")
    public suspend
    fun featuresRule(argument: suspend ResourceTypeRegistrationPropertiesFeaturesRuleArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesFeaturesRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.featuresRule = mapped
    }

    /**
     * @param value
     */
    @JvmName("tctisnwbjwvlrmfw")
    public suspend
    fun identityManagement(`value`: ResourceTypeRegistrationPropertiesIdentityManagementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityManagement = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hwhgdvnfjtvfwboo")
    public suspend
    fun identityManagement(argument: suspend ResourceTypeRegistrationPropertiesIdentityManagementArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesIdentityManagementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identityManagement = mapped
    }

    /**
     * @param value
     */
    @JvmName("knbpmyhmjpwpftwc")
    public suspend fun isPureProxy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPureProxy = mapped
    }

    /**
     * @param value
     */
    @JvmName("vrxxkearnojlqyxe")
    public suspend fun linkedAccessChecks(`value`: List<LinkedAccessCheckArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedAccessChecks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wxklfqufnoxsyont")
    public suspend
    fun linkedAccessChecks(argument: List<suspend LinkedAccessCheckArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedAccessCheckArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedAccessChecks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gitmsyywnejktvih")
    public suspend fun linkedAccessChecks(
        vararg
        argument: suspend LinkedAccessCheckArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LinkedAccessCheckArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedAccessChecks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pxwrojurscnxvigh")
    public suspend fun linkedAccessChecks(argument: suspend LinkedAccessCheckArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedAccessCheckArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.linkedAccessChecks = mapped
    }

    /**
     * @param values
     */
    @JvmName("atbikfgdmfsiwndk")
    public suspend fun linkedAccessChecks(vararg values: LinkedAccessCheckArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedAccessChecks = mapped
    }

    /**
     * @param value
     */
    @JvmName("jschkxxfolmejnjq")
    public suspend fun loggingRules(`value`: List<LoggingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eounncmcskesssgi")
    public suspend fun loggingRules(argument: List<suspend LoggingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { LoggingRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.loggingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rrimxftxvybriasy")
    public suspend fun loggingRules(vararg argument: suspend LoggingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { LoggingRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.loggingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cafcrterahtakyfg")
    public suspend fun loggingRules(argument: suspend LoggingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LoggingRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loggingRules = mapped
    }

    /**
     * @param values
     */
    @JvmName("gpnxsesdxtdnolka")
    public suspend fun loggingRules(vararg values: LoggingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loggingRules = mapped
    }

    /**
     * @param value
     */
    @JvmName("rddhscxeujjscobv")
    public suspend fun management(`value`: ResourceTypeRegistrationPropertiesManagementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.management = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fsvwsuvjjlydxvki")
    public suspend
    fun management(argument: suspend ResourceTypeRegistrationPropertiesManagementArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesManagementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.management = mapped
    }

    /**
     * @param value
     */
    @JvmName("udwymifhllfaunxi")
    public suspend fun marketplaceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplaceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("icybgoobfnuivlgl")
    public suspend fun openApiConfiguration(`value`: OpenApiConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openApiConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bhifnuuyruifnamt")
    public suspend
    fun openApiConfiguration(argument: suspend OpenApiConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OpenApiConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.openApiConfiguration = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("lnrigbwhdbmixlyh")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("ylmcqufmnpkacdra")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("clsoofryekhqkqwi")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value
     */
    @JvmName("ophemlhuonnslgky")
    public suspend fun regionality(`value`: Either<String, Regionality>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionality = mapped
    }

    /**
     * @param value
     */
    @JvmName("jcnfeucpdkhqiajq")
    public fun regionality(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Regionality>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionality = mapped
    }

    /**
     * @param value
     */
    @JvmName("cwohrlhgbduswatj")
    public fun regionality(`value`: Regionality) {
        val toBeMapped = Either.ofRight<String, Regionality>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionality = mapped
    }

    /**
     * @param value
     */
    @JvmName("rcdwqbkxewmumryf")
    public suspend
    fun requestHeaderOptions(`value`: ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestHeaderOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eqxujnxthihwjsoy")
    public suspend
    fun requestHeaderOptions(argument: suspend ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.requestHeaderOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("kajnwhlsdebyuuom")
    public suspend fun requiredFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param values
     */
    @JvmName("isusvsthuvrgxuqr")
    public suspend fun requiredFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param value
     */
    @JvmName("wngrdmdxhsnmjqyr")
    public suspend
    fun resourceConcurrencyControlOptions(`value`: Map<String, ResourceConcurrencyControlOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceConcurrencyControlOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ljbapyhiryivbvqp")
    public suspend fun resourceConcurrencyControlOptions(
        vararg
        argument: Pair<String, suspend ResourceConcurrencyControlOptionArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ResourceConcurrencyControlOptionArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.resourceConcurrencyControlOptions = mapped
    }

    /**
     * @param values
     */
    @JvmName("vrsidfgvauqiucxg")
    public fun resourceConcurrencyControlOptions(
        vararg
        values: Pair<String, ResourceConcurrencyControlOptionArgs>,
    ) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceConcurrencyControlOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("ysrtpogcodxjngwn")
    public suspend fun resourceDeletionPolicy(`value`: Either<String, ResourceDeletionPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceDeletionPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("lmdbhplxtqykotsk")
    public fun resourceDeletionPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceDeletionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceDeletionPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("pbmhdiiqpefexfvg")
    public fun resourceDeletionPolicy(`value`: ResourceDeletionPolicy) {
        val toBeMapped = Either.ofRight<String, ResourceDeletionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceDeletionPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("vhhngtppgolkihhw")
    public suspend
    fun resourceGraphConfiguration(`value`: ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGraphConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nkmixdiqfyanfqdv")
    public suspend
    fun resourceGraphConfiguration(argument: suspend ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.resourceGraphConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("xtjwrxaqygofjurn")
    public suspend
    fun resourceMovePolicy(`value`: ResourceTypeRegistrationPropertiesResourceMovePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceMovePolicy = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xuiqpcklboffopmm")
    public suspend
    fun resourceMovePolicy(argument: suspend ResourceTypeRegistrationPropertiesResourceMovePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesResourceMovePolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.resourceMovePolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("axecvmflcposvaip")
    public suspend fun routingType(`value`: Either<String, RoutingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    /**
     * @param value
     */
    @JvmName("tuccymyjpdptfmol")
    public fun routingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoutingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    /**
     * @param value
     */
    @JvmName("tahwpdtecrsfvhmb")
    public fun routingType(`value`: RoutingType) {
        val toBeMapped = Either.ofRight<String, RoutingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    /**
     * @param value
     */
    @JvmName("pgpeykrjisacmtlj")
    public suspend fun serviceTreeInfos(`value`: List<ServiceTreeInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceTreeInfos = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vqxewxaawsyxjjyq")
    public suspend
    fun serviceTreeInfos(argument: List<suspend ServiceTreeInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceTreeInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceTreeInfos = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gynpyyjxtaneaiec")
    public suspend fun serviceTreeInfos(
        vararg
        argument: suspend ServiceTreeInfoArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceTreeInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceTreeInfos = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ymgqcyjwkfwnpgpt")
    public suspend fun serviceTreeInfos(argument: suspend ServiceTreeInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceTreeInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serviceTreeInfos = mapped
    }

    /**
     * @param values
     */
    @JvmName("qstjbnpiscwhivtp")
    public suspend fun serviceTreeInfos(vararg values: ServiceTreeInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceTreeInfos = mapped
    }

    /**
     * @param value
     */
    @JvmName("hvgxhvqooxbyphps")
    public suspend
    fun subscriptionLifecycleNotificationSpecifications(`value`: ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionLifecycleNotificationSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oquvrfochaunmtfi")
    public suspend
    fun subscriptionLifecycleNotificationSpecifications(argument: suspend ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.subscriptionLifecycleNotificationSpecifications = mapped
    }

    /**
     * @param value
     */
    @JvmName("laujfwagldrdimcd")
    public suspend fun subscriptionStateRules(`value`: List<SubscriptionStateRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionStateRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dkfgglonqksymurk")
    public suspend
    fun subscriptionStateRules(argument: List<suspend SubscriptionStateRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubscriptionStateRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subscriptionStateRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uscjyxssnxdjkhpf")
    public suspend fun subscriptionStateRules(
        vararg
        argument: suspend SubscriptionStateRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SubscriptionStateRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subscriptionStateRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wlmqhjkhmnxrhrlb")
    public suspend
    fun subscriptionStateRules(argument: suspend SubscriptionStateRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubscriptionStateRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subscriptionStateRules = mapped
    }

    /**
     * @param values
     */
    @JvmName("fnrocttkcrxbcqkw")
    public suspend fun subscriptionStateRules(vararg values: SubscriptionStateRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionStateRules = mapped
    }

    /**
     * @param value
     */
    @JvmName("nyqdiwhefpkdeudk")
    public suspend fun swaggerSpecifications(`value`: List<SwaggerSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.swaggerSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ylbqhnplteiuknbo")
    public suspend
    fun swaggerSpecifications(argument: List<suspend SwaggerSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SwaggerSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.swaggerSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mpgoahrwsronakvf")
    public suspend fun swaggerSpecifications(
        vararg
        argument: suspend SwaggerSpecificationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SwaggerSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.swaggerSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vupaqvxeouxnrkil")
    public suspend
    fun swaggerSpecifications(argument: suspend SwaggerSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SwaggerSpecificationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.swaggerSpecifications = mapped
    }

    /**
     * @param values
     */
    @JvmName("hlfdxbopucddctuf")
    public suspend fun swaggerSpecifications(vararg values: SwaggerSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.swaggerSpecifications = mapped
    }

    /**
     * @param value
     */
    @JvmName("babcbnqchepaodwb")
    public suspend
    fun templateDeploymentOptions(`value`: ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateDeploymentOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bpuhhwmimdmqptmh")
    public suspend
    fun templateDeploymentOptions(argument: suspend ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.templateDeploymentOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("kfsrxdxetkfbcrus")
    public suspend fun throttlingRules(`value`: List<ThrottlingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttlingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("soyrsyddfcvnvgdg")
    public suspend fun throttlingRules(argument: List<suspend ThrottlingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThrottlingRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.throttlingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ipjjlmnxpbtovbci")
    public suspend fun throttlingRules(
        vararg
        argument: suspend ThrottlingRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ThrottlingRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.throttlingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hjdywopsasyeaslr")
    public suspend fun throttlingRules(argument: suspend ThrottlingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ThrottlingRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.throttlingRules = mapped
    }

    /**
     * @param values
     */
    @JvmName("vslbsitlphktovup")
    public suspend fun throttlingRules(vararg values: ThrottlingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.throttlingRules = mapped
    }

    internal fun build(): ResourceTypeRegistrationPropertiesArgs =
        ResourceTypeRegistrationPropertiesArgs(
            allowedUnauthorizedActions = allowedUnauthorizedActions,
            authorizationActionMappings = authorizationActionMappings,
            checkNameAvailabilitySpecifications = checkNameAvailabilitySpecifications,
            defaultApiVersion = defaultApiVersion,
            disallowedActionVerbs = disallowedActionVerbs,
            enableAsyncOperation = enableAsyncOperation,
            enableThirdPartyS2S = enableThirdPartyS2S,
            endpoints = endpoints,
            extendedLocations = extendedLocations,
            extensionOptions = extensionOptions,
            featuresRule = featuresRule,
            identityManagement = identityManagement,
            isPureProxy = isPureProxy,
            linkedAccessChecks = linkedAccessChecks,
            loggingRules = loggingRules,
            management = management,
            marketplaceType = marketplaceType,
            openApiConfiguration = openApiConfiguration,
            provisioningState = provisioningState,
            regionality = regionality,
            requestHeaderOptions = requestHeaderOptions,
            requiredFeatures = requiredFeatures,
            resourceConcurrencyControlOptions = resourceConcurrencyControlOptions,
            resourceDeletionPolicy = resourceDeletionPolicy,
            resourceGraphConfiguration = resourceGraphConfiguration,
            resourceMovePolicy = resourceMovePolicy,
            routingType = routingType,
            serviceTreeInfos = serviceTreeInfos,
            subscriptionLifecycleNotificationSpecifications = subscriptionLifecycleNotificationSpecifications,
            subscriptionStateRules = subscriptionStateRules,
            swaggerSpecifications = swaggerSpecifications,
            templateDeploymentOptions = templateDeploymentOptions,
            throttlingRules = throttlingRules,
        )
}
