@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property capabilities
 * @property capacity
 * @property costs
 * @property family
 * @property kind
 * @property locationInfo
 * @property locations
 * @property name
 * @property requiredFeatures
 * @property requiredQuotaIds
 * @property size
 * @property tier
 */
public data class SkuSettingArgs(
    public val capabilities: Output<List<SkuCapabilityArgs>>? = null,
    public val capacity: Output<SkuSettingCapacityArgs>? = null,
    public val costs: Output<List<SkuCostArgs>>? = null,
    public val family: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val locationInfo: Output<List<SkuLocationInfoArgs>>? = null,
    public val locations: Output<List<String>>? = null,
    public val name: Output<String>,
    public val requiredFeatures: Output<List<String>>? = null,
    public val requiredQuotaIds: Output<List<String>>? = null,
    public val size: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs =
        com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs.builder()
            .capabilities(
                capabilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .capacity(capacity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .costs(costs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .family(family?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .locationInfo(
                locationInfo?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .requiredFeatures(requiredFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .requiredQuotaIds(requiredQuotaIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuSettingArgs].
 */
@PulumiTagMarker
public class SkuSettingArgsBuilder internal constructor() {
    private var capabilities: Output<List<SkuCapabilityArgs>>? = null

    private var capacity: Output<SkuSettingCapacityArgs>? = null

    private var costs: Output<List<SkuCostArgs>>? = null

    private var family: Output<String>? = null

    private var kind: Output<String>? = null

    private var locationInfo: Output<List<SkuLocationInfoArgs>>? = null

    private var locations: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var requiredFeatures: Output<List<String>>? = null

    private var requiredQuotaIds: Output<List<String>>? = null

    private var size: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("mlqfkvflmertewkf")
    public suspend fun capabilities(`value`: Output<List<SkuCapabilityArgs>>) {
        this.capabilities = value
    }

    @JvmName("pdeaeifvxowrvogs")
    public suspend fun capabilities(vararg values: Output<SkuCapabilityArgs>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("apsjehpjtipksgyn")
    public suspend fun capabilities(values: List<Output<SkuCapabilityArgs>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("arhgehcgiwbcffax")
    public suspend fun capacity(`value`: Output<SkuSettingCapacityArgs>) {
        this.capacity = value
    }

    /**
     * @param value
     */
    @JvmName("kkrglwhddxgewcik")
    public suspend fun costs(`value`: Output<List<SkuCostArgs>>) {
        this.costs = value
    }

    @JvmName("ejskipsxqcxjowhr")
    public suspend fun costs(vararg values: Output<SkuCostArgs>) {
        this.costs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vehjjafspbykydtj")
    public suspend fun costs(values: List<Output<SkuCostArgs>>) {
        this.costs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("tvxtvkjoqqotkbml")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value
     */
    @JvmName("vqglguklgmmrxlpo")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value
     */
    @JvmName("pnlxwhjjdbvglahl")
    public suspend fun locationInfo(`value`: Output<List<SkuLocationInfoArgs>>) {
        this.locationInfo = value
    }

    @JvmName("ebctakokpfxdaeyr")
    public suspend fun locationInfo(vararg values: Output<SkuLocationInfoArgs>) {
        this.locationInfo = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("cviuwwrlejgclsmt")
    public suspend fun locationInfo(values: List<Output<SkuLocationInfoArgs>>) {
        this.locationInfo = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("rqthlhcldbkmcqfd")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("dowivaxhxgppnqsv")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("whorecnyvgdxqpoj")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("iajwvjchgfdexuqk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("muacnikjipppttdv")
    public suspend fun requiredFeatures(`value`: Output<List<String>>) {
        this.requiredFeatures = value
    }

    @JvmName("vvsbfmxiauenhswx")
    public suspend fun requiredFeatures(vararg values: Output<String>) {
        this.requiredFeatures = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("mrbluiqeceydsryp")
    public suspend fun requiredFeatures(values: List<Output<String>>) {
        this.requiredFeatures = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("petalmtvrqlustub")
    public suspend fun requiredQuotaIds(`value`: Output<List<String>>) {
        this.requiredQuotaIds = value
    }

    @JvmName("enhbmxfydfahbepv")
    public suspend fun requiredQuotaIds(vararg values: Output<String>) {
        this.requiredQuotaIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("nqwomycbyghdwvls")
    public suspend fun requiredQuotaIds(values: List<Output<String>>) {
        this.requiredQuotaIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ptfufqhpjrvbdcbd")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value
     */
    @JvmName("pkmujneyngfedtjt")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value
     */
    @JvmName("atcujvujbelpqhbj")
    public suspend fun capabilities(`value`: List<SkuCapabilityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cvkvcchtsgxdjbir")
    public suspend fun capabilities(argument: List<suspend SkuCapabilityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SkuCapabilityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uyaiasvrblrrpcit")
    public suspend fun capabilities(vararg argument: suspend SkuCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SkuCapabilityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("whsvtkysqnpygnqc")
    public suspend fun capabilities(argument: suspend SkuCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuCapabilityArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param values
     */
    @JvmName("hgvaxwupcpjflqha")
    public suspend fun capabilities(vararg values: SkuCapabilityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value
     */
    @JvmName("stgpbaryqbsutypo")
    public suspend fun capacity(`value`: SkuSettingCapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uehmpmsrkxpghxiv")
    public suspend fun capacity(argument: suspend SkuSettingCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = SkuSettingCapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacity = mapped
    }

    /**
     * @param value
     */
    @JvmName("wpvvvxpldiwswgsl")
    public suspend fun costs(`value`: List<SkuCostArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gittflxinwoekyxt")
    public suspend fun costs(argument: List<suspend SkuCostArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SkuCostArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.costs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ixgniametfibeiqc")
    public suspend fun costs(vararg argument: suspend SkuCostArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SkuCostArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.costs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ikgtdckjdiovmqij")
    public suspend fun costs(argument: suspend SkuCostArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuCostArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.costs = mapped
    }

    /**
     * @param values
     */
    @JvmName("bbkyqxhpwsmudegj")
    public suspend fun costs(vararg values: SkuCostArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.costs = mapped
    }

    /**
     * @param value
     */
    @JvmName("etadroylffvdgvtj")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value
     */
    @JvmName("teeriuwuocarxipv")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value
     */
    @JvmName("whyqktokrsnmxljm")
    public suspend fun locationInfo(`value`: List<SkuLocationInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ljhvaicwnbefbkhk")
    public suspend fun locationInfo(argument: List<suspend SkuLocationInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SkuLocationInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.locationInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lbrpvysmexsekoom")
    public suspend fun locationInfo(vararg argument: suspend SkuLocationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SkuLocationInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.locationInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qgptqtthnhqyuavt")
    public suspend fun locationInfo(argument: suspend SkuLocationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuLocationInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.locationInfo = mapped
    }

    /**
     * @param values
     */
    @JvmName("ousvctymfsmgtgfq")
    public suspend fun locationInfo(vararg values: SkuLocationInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locationInfo = mapped
    }

    /**
     * @param value
     */
    @JvmName("uyjcajsextwubeee")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values
     */
    @JvmName("sqixbycpwjntadaw")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value
     */
    @JvmName("nhwkexvnyotecvfw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("ncwjgifgapdnocob")
    public suspend fun requiredFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param values
     */
    @JvmName("jdhqvmdcdmpygfyx")
    public suspend fun requiredFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param value
     */
    @JvmName("rbhigmuilecwigki")
    public suspend fun requiredQuotaIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredQuotaIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("sxchfmwmdprsghto")
    public suspend fun requiredQuotaIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredQuotaIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("porutlxomdrderex")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value
     */
    @JvmName("tkihbagmlqeygqlh")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuSettingArgs = SkuSettingArgs(
        capabilities = capabilities,
        capacity = capacity,
        costs = costs,
        family = family,
        kind = kind,
        locationInfo = locationInfo,
        locations = locations,
        name = name ?: throw PulumiNullFieldException("name"),
        requiredFeatures = requiredFeatures,
        requiredQuotaIds = requiredQuotaIds,
        size = size,
        tier = tier,
    )
}
