@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property completedRegions
 * @property failedOrSkippedRegions
 * @property nextTrafficRegion
 * @property nextTrafficRegionScheduledTime
 * @property subscriptionReregistrationResult
 */
public data class DefaultRolloutPropertiesResponseStatus(
    public val completedRegions: List<String>? = null,
    public val failedOrSkippedRegions: Map<String, ExtendedErrorInfoResponse>? = null,
    public val nextTrafficRegion: String? = null,
    public val nextTrafficRegionScheduledTime: String? = null,
    public val subscriptionReregistrationResult: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.DefaultRolloutPropertiesResponseStatus):
            DefaultRolloutPropertiesResponseStatus = DefaultRolloutPropertiesResponseStatus(
            completedRegions = javaType.completedRegions().map({ args0 -> args0 }),
            failedOrSkippedRegions = javaType.failedOrSkippedRegions().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.ExtendedErrorInfoResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            nextTrafficRegion = javaType.nextTrafficRegion().map({ args0 -> args0 }).orElse(null),
            nextTrafficRegionScheduledTime = javaType.nextTrafficRegionScheduledTime().map({ args0 ->
                args0
            }).orElse(null),
            subscriptionReregistrationResult = javaType.subscriptionReregistrationResult().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
