@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property capabilities
 * @property featuresRule
 * @property management
 * @property metadata
 * @property namespace
 * @property providerAuthentication
 * @property providerAuthorizations
 * @property providerHubMetadata
 * @property providerType
 * @property providerVersion
 * @property provisioningState The provisioned state of the resource.
 * @property requestHeaderOptions
 * @property requiredFeatures
 * @property subscriptionLifecycleNotificationSpecifications
 * @property templateDeploymentOptions
 */
public data class ProviderRegistrationResponseProperties(
    public val capabilities: List<ResourceProviderCapabilitiesResponse>? = null,
    public val featuresRule: ResourceProviderManifestPropertiesResponseFeaturesRule? = null,
    public val management: ResourceProviderManifestPropertiesResponseManagement? = null,
    public val metadata: Any? = null,
    public val namespace: String? = null,
    public val providerAuthentication:
    ResourceProviderManifestPropertiesResponseProviderAuthentication? = null,
    public val providerAuthorizations: List<ResourceProviderAuthorizationResponse>? = null,
    public val providerHubMetadata: ProviderRegistrationPropertiesResponseProviderHubMetadata? = null,
    public val providerType: String? = null,
    public val providerVersion: String? = null,
    public val provisioningState: String? = null,
    public val requestHeaderOptions: ResourceProviderManifestPropertiesResponseRequestHeaderOptions? =
        null,
    public val requiredFeatures: List<String>? = null,
    public val subscriptionLifecycleNotificationSpecifications:
    ProviderRegistrationPropertiesResponseSubscriptionLifecycleNotificationSpecifications? = null,
    public val templateDeploymentOptions:
    ResourceProviderManifestPropertiesResponseTemplateDeploymentOptions? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.ProviderRegistrationResponseProperties):
            ProviderRegistrationResponseProperties = ProviderRegistrationResponseProperties(
            capabilities = javaType.capabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceProviderCapabilitiesResponse.Companion.toKotlin(args0)
                })
            }),
            featuresRule = javaType.featuresRule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceProviderManifestPropertiesResponseFeaturesRule.Companion.toKotlin(args0)
                })
            }).orElse(null),
            management = javaType.management().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceProviderManifestPropertiesResponseManagement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            providerAuthentication = javaType.providerAuthentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceProviderManifestPropertiesResponseProviderAuthentication.Companion.toKotlin(args0)
                })
            }).orElse(null),
            providerAuthorizations = javaType.providerAuthorizations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceProviderAuthorizationResponse.Companion.toKotlin(args0)
                })
            }),
            providerHubMetadata = javaType.providerHubMetadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ProviderRegistrationPropertiesResponseProviderHubMetadata.Companion.toKotlin(args0)
                })
            }).orElse(null),
            providerType = javaType.providerType().map({ args0 -> args0 }).orElse(null),
            providerVersion = javaType.providerVersion().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            requestHeaderOptions = javaType.requestHeaderOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceProviderManifestPropertiesResponseRequestHeaderOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requiredFeatures = javaType.requiredFeatures().map({ args0 -> args0 }),
            subscriptionLifecycleNotificationSpecifications = javaType.subscriptionLifecycleNotificationSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ProviderRegistrationPropertiesResponseSubscriptionLifecycleNotificationSpecifications.Companion.toKotlin(args0)
                })
            }).orElse(null),
            templateDeploymentOptions = javaType.templateDeploymentOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceProviderManifestPropertiesResponseTemplateDeploymentOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
