@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin

import com.pulumi.azurenative.purview.kotlin.outputs.AccountPropertiesResponseAccountStatus
import com.pulumi.azurenative.purview.kotlin.outputs.AccountPropertiesResponseEndpoints
import com.pulumi.azurenative.purview.kotlin.outputs.AccountPropertiesResponseManagedResources
import com.pulumi.azurenative.purview.kotlin.outputs.AccountResponseSku
import com.pulumi.azurenative.purview.kotlin.outputs.CloudConnectorsResponse
import com.pulumi.azurenative.purview.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.purview.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.purview.kotlin.outputs.TrackedResourceResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.purview.kotlin.outputs.AccountPropertiesResponseAccountStatus.Companion.toKotlin as accountPropertiesResponseAccountStatusToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.AccountPropertiesResponseEndpoints.Companion.toKotlin as accountPropertiesResponseEndpointsToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.AccountPropertiesResponseManagedResources.Companion.toKotlin as accountPropertiesResponseManagedResourcesToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.AccountResponseSku.Companion.toKotlin as accountResponseSkuToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.CloudConnectorsResponse.Companion.toKotlin as cloudConnectorsResponseToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.TrackedResourceResponseSystemData.Companion.toKotlin as trackedResourceResponseSystemDataToKotlin

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource = com.pulumi.azurenative.purview.Account(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Account(builtJavaResource)
    }
}

/**
 * Account resource
 * Azure REST API version: 2021-12-01. Prior API version in Azure Native 1.x: 2020-12-01-preview.
 * Other available API versions: 2020-12-01-preview, 2021-07-01.
 * ## Example Usage
 * ### Accounts_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.Purview.Account("account", new()
 *     {
 *         AccountName = "account1",
 *         Location = "West US 2",
 *         ManagedResourceGroupName = "custom-rgname",
 *         ManagedResourcesPublicNetworkAccess = "Enabled",
 *         ResourceGroupName = "SampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/purview/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := purview.NewAccount(ctx, "account", &purview.AccountArgs{
 * 			AccountName:                         pulumi.String("account1"),
 * 			Location:                            pulumi.String("West US 2"),
 * 			ManagedResourceGroupName:            pulumi.String("custom-rgname"),
 * 			ManagedResourcesPublicNetworkAccess: pulumi.String("Enabled"),
 * 			ResourceGroupName:                   pulumi.String("SampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.purview.Account;
 * import com.pulumi.azurenative.purview.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("account1")
 *             .location("West US 2")
 *             .managedResourceGroupName("custom-rgname")
 *             .managedResourcesPublicNetworkAccess("Enabled")
 *             .resourceGroupName("SampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:purview:Account account1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Purview/accounts/{accountName}
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.azurenative.purview.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * Gets or sets the status of the account.
     */
    public val accountStatus: Output<AccountPropertiesResponseAccountStatus>
        get() = javaResource.accountStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                accountPropertiesResponseAccountStatusToKotlin(args0)
            })
        })

    /**
     * Cloud connectors.
     * External cloud identifier used as part of scanning configuration.
     */
    public val cloudConnectors: Output<CloudConnectorsResponse>?
        get() = javaResource.cloudConnectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cloudConnectorsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the time at which the entity was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Gets the creator of the entity.
     */
    public val createdBy: Output<String>
        get() = javaResource.createdBy().applyValue({ args0 -> args0 })

    /**
     * Gets the creators of the entity's object id.
     */
    public val createdByObjectId: Output<String>
        get() = javaResource.createdByObjectId().applyValue({ args0 -> args0 })

    /**
     * The URIs that are the public endpoints of the account.
     */
    public val endpoints: Output<AccountPropertiesResponseEndpoints>
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.let({ args0 ->
                accountPropertiesResponseEndpointsToKotlin(args0)
            })
        })

    /**
     * Gets or sets the friendly name.
     */
    public val friendlyName: Output<String>
        get() = javaResource.friendlyName().applyValue({ args0 -> args0 })

    /**
     * Identity Info on the tracked resource
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     *  Gets or sets the state of managed eventhub. If enabled managed eventhub will be created, if disabled the managed eventhub will be removed.
     */
    public val managedEventHubState: Output<String>?
        get() = javaResource.managedEventHubState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the managed resource group name
     */
    public val managedResourceGroupName: Output<String>?
        get() = javaResource.managedResourceGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the resource identifiers of the managed resources.
     */
    public val managedResources: Output<AccountPropertiesResponseManagedResources>
        get() = javaResource.managedResources().applyValue({ args0 ->
            args0.let({ args0 ->
                accountPropertiesResponseManagedResourcesToKotlin(args0)
            })
        })

    /**
     * Gets or sets the public network access for managed resources.
     */
    public val managedResourcesPublicNetworkAccess: Output<String>?
        get() = javaResource.managedResourcesPublicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Gets or sets the name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the private endpoint connections information.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Gets or sets the state of the provisioning.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the public network access.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the Sku.
     */
    public val sku: Output<AccountResponseSku>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                accountResponseSkuToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<TrackedResourceResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                trackedResourceResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Tags on the azure resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.purview.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.azurenative.purview.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit):
    Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
