@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin

import com.pulumi.azurenative.purview.KafkaConfigurationArgs.builder
import com.pulumi.azurenative.purview.kotlin.enums.EventHubType
import com.pulumi.azurenative.purview.kotlin.enums.EventStreamingState
import com.pulumi.azurenative.purview.kotlin.enums.EventStreamingType
import com.pulumi.azurenative.purview.kotlin.inputs.CredentialsArgs
import com.pulumi.azurenative.purview.kotlin.inputs.CredentialsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration of the event streaming service resource attached to the Purview account for kafka notifications.
 * Azure REST API version: 2021-12-01.
 * ## Example Usage
 * ### KafkaConfigurations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kafkaConfiguration = new AzureNative.Purview.KafkaConfiguration("kafkaConfiguration", new()
 *     {
 *         AccountName = "account1",
 *         ConsumerGroup = "consumerGroup",
 *         Credentials = new AzureNative.Purview.Inputs.CredentialsArgs
 *         {
 *             IdentityId = "/subscriptions/47e8596d-ee73-4eb2-b6b4-cc13c2b87ssd/resourceGroups/testRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testId",
 *             Type = "UserAssigned",
 *         },
 *         EventHubPartitionId = "partitionId",
 *         EventHubResourceId = "/subscriptions/225be6fe-ec1c-4d51-a368-f69348d2e6c5/resourceGroups/testRG/providers/Microsoft.EventHub/namespaces/eventHubNameSpaceName",
 *         EventHubType = "Notification",
 *         EventStreamingState = "Enabled",
 *         EventStreamingType = "Azure",
 *         KafkaConfigurationName = "kafkaConfigName",
 *         ResourceGroupName = "rgpurview",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/purview/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := purview.NewKafkaConfiguration(ctx, "kafkaConfiguration", &purview.KafkaConfigurationArgs{
 * 			AccountName:   pulumi.String("account1"),
 * 			ConsumerGroup: pulumi.String("consumerGroup"),
 * 			Credentials: &purview.CredentialsArgs{
 * 				IdentityId: pulumi.String("/subscriptions/47e8596d-ee73-4eb2-b6b4-cc13c2b87ssd/resourceGroups/testRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testId"),
 * 				Type:       pulumi.String("UserAssigned"),
 * 			},
 * 			EventHubPartitionId:    pulumi.String("partitionId"),
 * 			EventHubResourceId:     pulumi.String("/subscriptions/225be6fe-ec1c-4d51-a368-f69348d2e6c5/resourceGroups/testRG/providers/Microsoft.EventHub/namespaces/eventHubNameSpaceName"),
 * 			EventHubType:           pulumi.String("Notification"),
 * 			EventStreamingState:    pulumi.String("Enabled"),
 * 			EventStreamingType:     pulumi.String("Azure"),
 * 			KafkaConfigurationName: pulumi.String("kafkaConfigName"),
 * 			ResourceGroupName:      pulumi.String("rgpurview"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.purview.KafkaConfiguration;
 * import com.pulumi.azurenative.purview.KafkaConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kafkaConfiguration = new KafkaConfiguration("kafkaConfiguration", KafkaConfigurationArgs.builder()
 *             .accountName("account1")
 *             .consumerGroup("consumerGroup")
 *             .credentials(Map.ofEntries(
 *                 Map.entry("identityId", "/subscriptions/47e8596d-ee73-4eb2-b6b4-cc13c2b87ssd/resourceGroups/testRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testId"),
 *                 Map.entry("type", "UserAssigned")
 *             ))
 *             .eventHubPartitionId("partitionId")
 *             .eventHubResourceId("/subscriptions/225be6fe-ec1c-4d51-a368-f69348d2e6c5/resourceGroups/testRG/providers/Microsoft.EventHub/namespaces/eventHubNameSpaceName")
 *             .eventHubType("Notification")
 *             .eventStreamingState("Enabled")
 *             .eventStreamingType("Azure")
 *             .kafkaConfigurationName("kafkaConfigName")
 *             .resourceGroupName("rgpurview")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:purview:KafkaConfiguration kafkaConfigName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Purview/accounts/{accountName}/kafkaConfigurations/{kafkaConfigurationName}
 * ```
 * @property accountName The name of the account.
 * @property consumerGroup Consumer group for hook event hub.
 * @property credentials Credentials to access event hub.
 * @property eventHubPartitionId Optional partition Id for notification event hub. If not set, all partitions will be leveraged.
 * @property eventHubResourceId
 * @property eventHubType The event hub type.
 * @property eventStreamingState The state of the event streaming service
 * @property eventStreamingType The event streaming service type
 * @property kafkaConfigurationName The kafka configuration name.
 * @property resourceGroupName The resource group name.
 */
public data class KafkaConfigurationArgs(
    public val accountName: Output<String>? = null,
    public val consumerGroup: Output<String>? = null,
    public val credentials: Output<CredentialsArgs>? = null,
    public val eventHubPartitionId: Output<String>? = null,
    public val eventHubResourceId: Output<String>? = null,
    public val eventHubType: Output<Either<String, EventHubType>>? = null,
    public val eventStreamingState: Output<Either<String, EventStreamingState>>? = null,
    public val eventStreamingType: Output<Either<String, EventStreamingType>>? = null,
    public val kafkaConfigurationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.purview.KafkaConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.purview.KafkaConfigurationArgs =
        com.pulumi.azurenative.purview.KafkaConfigurationArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .consumerGroup(consumerGroup?.applyValue({ args0 -> args0 }))
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventHubPartitionId(eventHubPartitionId?.applyValue({ args0 -> args0 }))
            .eventHubResourceId(eventHubResourceId?.applyValue({ args0 -> args0 }))
            .eventHubType(
                eventHubType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .eventStreamingState(
                eventStreamingState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .eventStreamingType(
                eventStreamingType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .kafkaConfigurationName(kafkaConfigurationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KafkaConfigurationArgs].
 */
@PulumiTagMarker
public class KafkaConfigurationArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var consumerGroup: Output<String>? = null

    private var credentials: Output<CredentialsArgs>? = null

    private var eventHubPartitionId: Output<String>? = null

    private var eventHubResourceId: Output<String>? = null

    private var eventHubType: Output<Either<String, EventHubType>>? = null

    private var eventStreamingState: Output<Either<String, EventStreamingState>>? = null

    private var eventStreamingType: Output<Either<String, EventStreamingType>>? = null

    private var kafkaConfigurationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the account.
     */
    @JvmName("myxjgqiqposuljcg")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Consumer group for hook event hub.
     */
    @JvmName("qyfhaynqyuskhffd")
    public suspend fun consumerGroup(`value`: Output<String>) {
        this.consumerGroup = value
    }

    /**
     * @param value Credentials to access event hub.
     */
    @JvmName("rnsaotetxrrypykn")
    public suspend fun credentials(`value`: Output<CredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value Optional partition Id for notification event hub. If not set, all partitions will be leveraged.
     */
    @JvmName("cvunnewosrkirsah")
    public suspend fun eventHubPartitionId(`value`: Output<String>) {
        this.eventHubPartitionId = value
    }

    /**
     * @param value
     */
    @JvmName("rglutphigymaoucb")
    public suspend fun eventHubResourceId(`value`: Output<String>) {
        this.eventHubResourceId = value
    }

    /**
     * @param value The event hub type.
     */
    @JvmName("seykdqvfpmuosrxc")
    public suspend fun eventHubType(`value`: Output<Either<String, EventHubType>>) {
        this.eventHubType = value
    }

    /**
     * @param value The state of the event streaming service
     */
    @JvmName("pclxiiiklfqrtrue")
    public suspend fun eventStreamingState(`value`: Output<Either<String, EventStreamingState>>) {
        this.eventStreamingState = value
    }

    /**
     * @param value The event streaming service type
     */
    @JvmName("bteudbepvsvjipwv")
    public suspend fun eventStreamingType(`value`: Output<Either<String, EventStreamingType>>) {
        this.eventStreamingType = value
    }

    /**
     * @param value The kafka configuration name.
     */
    @JvmName("xuqlesjniijfxbdj")
    public suspend fun kafkaConfigurationName(`value`: Output<String>) {
        this.kafkaConfigurationName = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("uycgngqsqdchgsxw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the account.
     */
    @JvmName("qwfdowtokmpkwiiq")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Consumer group for hook event hub.
     */
    @JvmName("fbljyvnhrntqxhem")
    public suspend fun consumerGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroup = mapped
    }

    /**
     * @param value Credentials to access event hub.
     */
    @JvmName("dclmdilqtbmqfjxp")
    public suspend fun credentials(`value`: CredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Credentials to access event hub.
     */
    @JvmName("sqvxbtwlmcwatwic")
    public suspend fun credentials(argument: suspend CredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value Optional partition Id for notification event hub. If not set, all partitions will be leveraged.
     */
    @JvmName("qgerplmjhcewfotr")
    public suspend fun eventHubPartitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubPartitionId = mapped
    }

    /**
     * @param value
     */
    @JvmName("qydkpjofcnyfnrgh")
    public suspend fun eventHubResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubResourceId = mapped
    }

    /**
     * @param value The event hub type.
     */
    @JvmName("cpflajwyffgcpvdg")
    public suspend fun eventHubType(`value`: Either<String, EventHubType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubType = mapped
    }

    /**
     * @param value The event hub type.
     */
    @JvmName("xjlmvlgtxidfskjt")
    public fun eventHubType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventHubType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubType = mapped
    }

    /**
     * @param value The event hub type.
     */
    @JvmName("vwlnobpvpcnsutmo")
    public fun eventHubType(`value`: EventHubType) {
        val toBeMapped = Either.ofRight<String, EventHubType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubType = mapped
    }

    /**
     * @param value The state of the event streaming service
     */
    @JvmName("yedpvdjusgoekshc")
    public suspend fun eventStreamingState(`value`: Either<String, EventStreamingState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventStreamingState = mapped
    }

    /**
     * @param value The state of the event streaming service
     */
    @JvmName("mtoyqapylchkdxsa")
    public fun eventStreamingState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventStreamingState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventStreamingState = mapped
    }

    /**
     * @param value The state of the event streaming service
     */
    @JvmName("iipgbbmuutpnmlmb")
    public fun eventStreamingState(`value`: EventStreamingState) {
        val toBeMapped = Either.ofRight<String, EventStreamingState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventStreamingState = mapped
    }

    /**
     * @param value The event streaming service type
     */
    @JvmName("fihagohlxvriwpgl")
    public suspend fun eventStreamingType(`value`: Either<String, EventStreamingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventStreamingType = mapped
    }

    /**
     * @param value The event streaming service type
     */
    @JvmName("nepxiuntrxjglodo")
    public fun eventStreamingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventStreamingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventStreamingType = mapped
    }

    /**
     * @param value The event streaming service type
     */
    @JvmName("eybvnimyjbdtulhn")
    public fun eventStreamingType(`value`: EventStreamingType) {
        val toBeMapped = Either.ofRight<String, EventStreamingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventStreamingType = mapped
    }

    /**
     * @param value The kafka configuration name.
     */
    @JvmName("igjukrjdiqphjddc")
    public suspend fun kafkaConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaConfigurationName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qmudkbnwtesdukau")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): KafkaConfigurationArgs = KafkaConfigurationArgs(
        accountName = accountName,
        consumerGroup = consumerGroup,
        credentials = credentials,
        eventHubPartitionId = eventHubPartitionId,
        eventHubResourceId = eventHubResourceId,
        eventHubType = eventHubType,
        eventStreamingState = eventStreamingState,
        eventStreamingType = eventStreamingType,
        kafkaConfigurationName = kafkaConfigurationName,
        resourceGroupName = resourceGroupName,
    )
}
