@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin

import com.pulumi.azurenative.purview.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.purview.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.azurenative.purview.kotlin.outputs.ProxyResourceResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.purview.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.ProxyResourceResponseSystemData.Companion.toKotlin as proxyResourceResponseSystemDataToKotlin

/**
 * Builder for [PrivateEndpointConnection].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.purview.PrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * A private endpoint connection class.
 * Azure REST API version: 2021-12-01. Prior API version in Azure Native 1.x: 2020-12-01-preview.
 * Other available API versions: 2021-07-01.
 * ## Example Usage
 * ### PrivateEndpointConnections_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.Purview.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         AccountName = "account1",
 *         PrivateEndpointConnectionName = "privateEndpointConnection1",
 *         PrivateLinkServiceConnectionState = new AzureNative.Purview.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Approved by johndoe@company.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "SampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/purview/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := purview.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &purview.PrivateEndpointConnectionArgs{
 * 			AccountName:                   pulumi.String("account1"),
 * 			PrivateEndpointConnectionName: pulumi.String("privateEndpointConnection1"),
 * 			PrivateLinkServiceConnectionState: &purview.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Approved by johndoe@company.com"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.purview.PrivateEndpointConnection;
 * import com.pulumi.azurenative.purview.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .accountName("account1")
 *             .privateEndpointConnectionName("privateEndpointConnection1")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "Approved by johndoe@company.com"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("SampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:purview:PrivateEndpointConnection privateEndpointConnection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Purview/accounts/{accountName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class PrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.purview.PrivateEndpointConnection,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionMapper) {
    /**
     * Gets or sets the name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The private endpoint information.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The private link service connection state.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateLinkServiceConnectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<ProxyResourceResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                proxyResourceResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionMapper : ResourceMapper<PrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.purview.PrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnection =
        PrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.purview.PrivateEndpointConnection,
        )
}

/**
 * @see [PrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnection].
 */
public suspend fun privateEndpointConnection(
    name: String,
    block: suspend PrivateEndpointConnectionResourceBuilder.() -> Unit,
): PrivateEndpointConnection {
    val builder = PrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnection(name: String): PrivateEndpointConnection {
    val builder = PrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
