@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.inputs

import com.pulumi.azurenative.purview.inputs.ListAccountKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the account.
 * @property resourceGroupName The resource group name.
 */
public data class ListAccountKeysPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.purview.inputs.ListAccountKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.purview.inputs.ListAccountKeysPlainArgs =
        com.pulumi.azurenative.purview.inputs.ListAccountKeysPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListAccountKeysPlainArgs].
 */
@PulumiTagMarker
public class ListAccountKeysPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the account.
     */
    @JvmName("eegojsjebvdsoeaw")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("hnjafytqfddavlnc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListAccountKeysPlainArgs = ListAccountKeysPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
