@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The private link service connection state.
 * @property actionsRequired The required actions.
 * @property description The description.
 * @property status The status.
 */
public data class PrivateLinkServiceConnectionStateResponse(
    public val actionsRequired: String? = null,
    public val description: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.PrivateLinkServiceConnectionStateResponse):
            PrivateLinkServiceConnectionStateResponse = PrivateLinkServiceConnectionStateResponse(
            actionsRequired = javaType.actionsRequired().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
