@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quantum.kotlin

import com.pulumi.azurenative.quantum.QuantumFunctions.getWorkspacePlain
import com.pulumi.azurenative.quantum.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.quantum.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.quantum.kotlin.outputs.GetWorkspaceResult
import com.pulumi.azurenative.quantum.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object QuantumFunctions {
    /**
     * Returns the Workspace resource associated with the given name.
     * Azure REST API version: 2022-01-10-preview.
     * @param argument null
     * @return The resource proxy definition object for quantum workspace.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        toKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group.
     * @param workspaceName The name of the quantum workspace resource.
     * @return The resource proxy definition object for quantum workspace.
     */
    public suspend fun getWorkspace(resourceGroupName: String, workspaceName: String):
        GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return toKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;quantum&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return The resource proxy definition object for quantum workspace.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }
}
