@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quantum.kotlin

import com.pulumi.azurenative.quantum.kotlin.outputs.ProviderResponse
import com.pulumi.azurenative.quantum.kotlin.outputs.QuantumWorkspaceResponseIdentity
import com.pulumi.azurenative.quantum.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.quantum.kotlin.outputs.ProviderResponse.Companion.toKotlin as providerResponseToKotlin
import com.pulumi.azurenative.quantum.kotlin.outputs.QuantumWorkspaceResponseIdentity.Companion.toKotlin as quantumWorkspaceResponseIdentityToKotlin
import com.pulumi.azurenative.quantum.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Workspace].
 */
@PulumiTagMarker
public class WorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceArgs = WorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceArgsBuilder.() -> Unit) {
        val builder = WorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workspace {
        val builtJavaResource = com.pulumi.azurenative.quantum.Workspace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workspace(builtJavaResource)
    }
}

/**
 * The resource proxy definition object for quantum workspace.
 * Azure REST API version: 2022-01-10-preview. Prior API version in Azure Native 1.x: 2019-11-04-preview.
 * ## Example Usage
 * ### QuantumWorkspacesPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Quantum.Workspace("workspace", new()
 *     {
 *         Location = "West US",
 *         Providers = new[]
 *         {
 *             new AzureNative.Quantum.Inputs.ProviderArgs
 *             {
 *                 ProviderId = "Honeywell",
 *                 ProviderSku = "Basic",
 *             },
 *             new AzureNative.Quantum.Inputs.ProviderArgs
 *             {
 *                 ProviderId = "IonQ",
 *                 ProviderSku = "Basic",
 *             },
 *             new AzureNative.Quantum.Inputs.ProviderArgs
 *             {
 *                 ProviderId = "OneQBit",
 *                 ProviderSku = "Basic",
 *             },
 *         },
 *         ResourceGroupName = "quantumResourcegroup",
 *         StorageAccount = "/subscriptions/1C4B2828-7D49-494F-933D-061373BE28C2/resourceGroups/quantumResourcegroup/providers/Microsoft.Storage/storageAccounts/testStorageAccount",
 *         WorkspaceName = "quantumworkspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/quantum/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quantum.NewWorkspace(ctx, "workspace", &quantum.WorkspaceArgs{
 * 			Location: pulumi.String("West US"),
 * 			Providers: []quantum.ProviderArgs{
 * 				{
 * 					ProviderId:  pulumi.String("Honeywell"),
 * 					ProviderSku: pulumi.String("Basic"),
 * 				},
 * 				{
 * 					ProviderId:  pulumi.String("IonQ"),
 * 					ProviderSku: pulumi.String("Basic"),
 * 				},
 * 				{
 * 					ProviderId:  pulumi.String("OneQBit"),
 * 					ProviderSku: pulumi.String("Basic"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("quantumResourcegroup"),
 * 			StorageAccount:    pulumi.String("/subscriptions/1C4B2828-7D49-494F-933D-061373BE28C2/resourceGroups/quantumResourcegroup/providers/Microsoft.Storage/storageAccounts/testStorageAccount"),
 * 			WorkspaceName:     pulumi.String("quantumworkspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.quantum.Workspace;
 * import com.pulumi.azurenative.quantum.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("West US")
 *             .providers(
 *                 Map.ofEntries(
 *                     Map.entry("providerId", "Honeywell"),
 *                     Map.entry("providerSku", "Basic")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("providerId", "IonQ"),
 *                     Map.entry("providerSku", "Basic")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("providerId", "OneQBit"),
 *                     Map.entry("providerSku", "Basic")
 *                 ))
 *             .resourceGroupName("quantumResourcegroup")
 *             .storageAccount("/subscriptions/1C4B2828-7D49-494F-933D-061373BE28C2/resourceGroups/quantumResourcegroup/providers/Microsoft.Storage/storageAccounts/testStorageAccount")
 *             .workspaceName("quantumworkspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:quantum:Workspace quantumworkspace1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}
 * ```
 */
public class Workspace internal constructor(
    override val javaResource: com.pulumi.azurenative.quantum.Workspace,
) : KotlinCustomResource(javaResource, WorkspaceMapper) {
    /**
     * The URI of the workspace endpoint.
     */
    public val endpointUri: Output<String>
        get() = javaResource.endpointUri().applyValue({ args0 -> args0 })

    /**
     * Managed Identity information.
     */
    public val identity: Output<QuantumWorkspaceResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    quantumWorkspaceResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of Providers selected for this Workspace
     */
    public val providers: Output<List<ProviderResponse>>?
        get() = javaResource.providers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> providerResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Provisioning status field
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * ARM Resource Id of the storage account associated with this workspace.
     */
    public val storageAccount: Output<String>?
        get() = javaResource.storageAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * System metadata
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Whether the current workspace is ready to accept Jobs.
     */
    public val usable: Output<String>
        get() = javaResource.usable().applyValue({ args0 -> args0 })
}

public object WorkspaceMapper : ResourceMapper<Workspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.quantum.Workspace::class == javaResource::class

    override fun map(javaResource: Resource): Workspace = Workspace(
        javaResource as
            com.pulumi.azurenative.quantum.Workspace,
    )
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workspace].
 */
public suspend fun workspace(name: String, block: suspend WorkspaceResourceBuilder.() -> Unit):
    Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspace(name: String): Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
