@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin.inputs

import com.pulumi.azurenative.quota.inputs.GetGroupQuotaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupQuotaName The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
 * @property mgId Management Group Id.
 */
public data class GetGroupQuotaPlainArgs(
    public val groupQuotaName: String,
    public val mgId: String,
) : ConvertibleToJava<com.pulumi.azurenative.quota.inputs.GetGroupQuotaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.quota.inputs.GetGroupQuotaPlainArgs =
        com.pulumi.azurenative.quota.inputs.GetGroupQuotaPlainArgs.builder()
            .groupQuotaName(groupQuotaName.let({ args0 -> args0 }))
            .mgId(mgId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupQuotaPlainArgs].
 */
@PulumiTagMarker
public class GetGroupQuotaPlainArgsBuilder internal constructor() {
    private var groupQuotaName: String? = null

    private var mgId: String? = null

    /**
     * @param value The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
     */
    @JvmName("bdqhfnrgehwrweya")
    public suspend fun groupQuotaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupQuotaName = mapped
    }

    /**
     * @param value Management Group Id.
     */
    @JvmName("ogtnfghwggjmcmso")
    public suspend fun mgId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mgId = mapped
    }

    internal fun build(): GetGroupQuotaPlainArgs = GetGroupQuotaPlainArgs(
        groupQuotaName = groupQuotaName ?: throw PulumiNullFieldException("groupQuotaName"),
        mgId = mgId ?: throw PulumiNullFieldException("mgId"),
    )
}
