@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Additional attribute to allow subscriptions to be part of the GroupQuota.
 * @property environment
 * @property groupId The grouping Id for the group quota. It can be management Group Id or ServiceTreeId if applicable.
 */
public data class AdditionalAttributesResponse(
    public val environment: Any? = null,
    public val groupId: GroupingIdResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.quota.outputs.AdditionalAttributesResponse):
            AdditionalAttributesResponse = AdditionalAttributesResponse(
            environment = javaType.environment().map({ args0 -> args0 }).orElse(null),
            groupId = javaType.groupId().let({ args0 ->
                com.pulumi.azurenative.quota.kotlin.outputs.GroupingIdResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
