@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.inputs

import com.pulumi.azurenative.recommendationsservice.inputs.AccountResourcePropertiesArgs.builder
import com.pulumi.azurenative.recommendationsservice.kotlin.enums.AccountConfiguration
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Account resource properties.
 * @property configuration Account configuration. This can only be set at RecommendationsService Account creation.
 * @property cors The list of CORS details.
 * @property endpointAuthentications The list of service endpoints authentication details.
 * @property reportsConnectionString Connection string to write Accounts reports to.
 */
public data class AccountResourcePropertiesArgs(
    public val configuration: Output<Either<String, AccountConfiguration>>? = null,
    public val cors: Output<List<CorsRuleArgs>>? = null,
    public val endpointAuthentications: Output<List<EndpointAuthenticationArgs>>? = null,
    public val reportsConnectionString: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recommendationsservice.inputs.AccountResourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recommendationsservice.inputs.AccountResourcePropertiesArgs =
        com.pulumi.azurenative.recommendationsservice.inputs.AccountResourcePropertiesArgs.builder()
            .configuration(
                configuration?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cors(cors?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .endpointAuthentications(
                endpointAuthentications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .reportsConnectionString(reportsConnectionString?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountResourcePropertiesArgs].
 */
@PulumiTagMarker
public class AccountResourcePropertiesArgsBuilder internal constructor() {
    private var configuration: Output<Either<String, AccountConfiguration>>? = null

    private var cors: Output<List<CorsRuleArgs>>? = null

    private var endpointAuthentications: Output<List<EndpointAuthenticationArgs>>? = null

    private var reportsConnectionString: Output<String>? = null

    /**
     * @param value Account configuration. This can only be set at RecommendationsService Account creation.
     */
    @JvmName("syuyoccecrijhevc")
    public suspend fun configuration(`value`: Output<Either<String, AccountConfiguration>>) {
        this.configuration = value
    }

    /**
     * @param value The list of CORS details.
     */
    @JvmName("lxtkejjddyxmpmue")
    public suspend fun cors(`value`: Output<List<CorsRuleArgs>>) {
        this.cors = value
    }

    @JvmName("nxybwlavfbwfglng")
    public suspend fun cors(vararg values: Output<CorsRuleArgs>) {
        this.cors = Output.all(values.asList())
    }

    /**
     * @param values The list of CORS details.
     */
    @JvmName("wtsxlsnmginmrvji")
    public suspend fun cors(values: List<Output<CorsRuleArgs>>) {
        this.cors = Output.all(values)
    }

    /**
     * @param value The list of service endpoints authentication details.
     */
    @JvmName("jvfxcqyhvmrvvpsq")
    public suspend fun endpointAuthentications(`value`: Output<List<EndpointAuthenticationArgs>>) {
        this.endpointAuthentications = value
    }

    @JvmName("gkbdikgrwpmxqpgi")
    public suspend fun endpointAuthentications(vararg values: Output<EndpointAuthenticationArgs>) {
        this.endpointAuthentications = Output.all(values.asList())
    }

    /**
     * @param values The list of service endpoints authentication details.
     */
    @JvmName("gohdyrtjkkbvjxbq")
    public suspend fun endpointAuthentications(values: List<Output<EndpointAuthenticationArgs>>) {
        this.endpointAuthentications = Output.all(values)
    }

    /**
     * @param value Connection string to write Accounts reports to.
     */
    @JvmName("qgmfudckglhwnpas")
    public suspend fun reportsConnectionString(`value`: Output<String>) {
        this.reportsConnectionString = value
    }

    /**
     * @param value Account configuration. This can only be set at RecommendationsService Account creation.
     */
    @JvmName("arathusnudtdobvm")
    public suspend fun configuration(`value`: Either<String, AccountConfiguration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value Account configuration. This can only be set at RecommendationsService Account creation.
     */
    @JvmName("ohcfwcodlffgtibr")
    public fun configuration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccountConfiguration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value Account configuration. This can only be set at RecommendationsService Account creation.
     */
    @JvmName("ymqpcmmqklyhyand")
    public fun configuration(`value`: AccountConfiguration) {
        val toBeMapped = Either.ofRight<String, AccountConfiguration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value The list of CORS details.
     */
    @JvmName("rxdlgcckjgkhrbod")
    public suspend fun cors(`value`: List<CorsRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param argument The list of CORS details.
     */
    @JvmName("vvbwvjqdtrvwdter")
    public suspend fun cors(argument: List<suspend CorsRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CorsRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param argument The list of CORS details.
     */
    @JvmName("nljnvjxevrivsqvc")
    public suspend fun cors(vararg argument: suspend CorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CorsRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param argument The list of CORS details.
     */
    @JvmName("lironafqbxycsfug")
    public suspend fun cors(argument: suspend CorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CorsRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param values The list of CORS details.
     */
    @JvmName("aobmwjstxclvvhfw")
    public suspend fun cors(vararg values: CorsRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param value The list of service endpoints authentication details.
     */
    @JvmName("fkphvyjgdcxiesfx")
    public suspend fun endpointAuthentications(`value`: List<EndpointAuthenticationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointAuthentications = mapped
    }

    /**
     * @param argument The list of service endpoints authentication details.
     */
    @JvmName("xvflvfmwwnyobxgj")
    public suspend
    fun endpointAuthentications(argument: List<suspend EndpointAuthenticationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointAuthenticationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpointAuthentications = mapped
    }

    /**
     * @param argument The list of service endpoints authentication details.
     */
    @JvmName("xyvkhmotmiwgsyhn")
    public suspend fun endpointAuthentications(
        vararg
        argument: suspend EndpointAuthenticationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EndpointAuthenticationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpointAuthentications = mapped
    }

    /**
     * @param argument The list of service endpoints authentication details.
     */
    @JvmName("iqvdhpaumgvjoson")
    public suspend
    fun endpointAuthentications(argument: suspend EndpointAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EndpointAuthenticationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpointAuthentications = mapped
    }

    /**
     * @param values The list of service endpoints authentication details.
     */
    @JvmName("hpcceskgfsowyrqj")
    public suspend fun endpointAuthentications(vararg values: EndpointAuthenticationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointAuthentications = mapped
    }

    /**
     * @param value Connection string to write Accounts reports to.
     */
    @JvmName("irbtcwcgxsofmjsj")
    public suspend fun reportsConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportsConnectionString = mapped
    }

    internal fun build(): AccountResourcePropertiesArgs = AccountResourcePropertiesArgs(
        configuration = configuration,
        cors = cors,
        endpointAuthentications = endpointAuthentications,
        reportsConnectionString = reportsConnectionString,
    )
}
