@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.inputs

import com.pulumi.azurenative.recommendationsservice.inputs.GetModelingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the RecommendationsService Account resource.
 * @property modelingName The name of the Modeling resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetModelingPlainArgs(
    public val accountName: String,
    public val modelingName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.recommendationsservice.inputs.GetModelingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.recommendationsservice.inputs.GetModelingPlainArgs =
        com.pulumi.azurenative.recommendationsservice.inputs.GetModelingPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .modelingName(modelingName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetModelingPlainArgs].
 */
@PulumiTagMarker
public class GetModelingPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var modelingName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the RecommendationsService Account resource.
     */
    @JvmName("kcoxitlhfhihgdnq")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Modeling resource.
     */
    @JvmName("xjvcfejceayulxkn")
    public suspend fun modelingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modelingName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fpyjrvnpsbbxfato")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetModelingPlainArgs = GetModelingPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        modelingName = modelingName ?: throw PulumiNullFieldException("modelingName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
