@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * CORS details.
 * @property allowedHeaders The request headers that the origin domain may specify on the CORS request.
 * @property allowedMethods The methods (HTTP request verbs) that the origin domain may use for a CORS request.
 * @property allowedOrigins The origin domains that are permitted to make a request against the service via CORS.
 * @property exposedHeaders The response headers to expose to CORS clients.
 * @property maxAgeInSeconds The number of seconds that the client/browser should cache a preflight response.
 */
public data class CorsRuleResponse(
    public val allowedHeaders: List<String>? = null,
    public val allowedMethods: List<String>? = null,
    public val allowedOrigins: List<String>,
    public val exposedHeaders: List<String>? = null,
    public val maxAgeInSeconds: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recommendationsservice.outputs.CorsRuleResponse):
            CorsRuleResponse = CorsRuleResponse(
            allowedHeaders = javaType.allowedHeaders().map({ args0 -> args0 }),
            allowedMethods = javaType.allowedMethods().map({ args0 -> args0 }),
            allowedOrigins = javaType.allowedOrigins().map({ args0 -> args0 }),
            exposedHeaders = javaType.exposedHeaders().map({ args0 -> args0 }),
            maxAgeInSeconds = javaType.maxAgeInSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
