@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.PrivateEndpointConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Private Endpoint Connection Response Properties
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-06-01.
 * ## Example Usage
 * ### Update PrivateEndpointConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.RecoveryServices.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "gaallatestpe2.5704c932-249a-490b-a142-1396838cd3b",
 *         Properties = new AzureNative.RecoveryServices.Inputs.PrivateEndpointConnectionArgs
 *         {
 *             GroupIds = new[]
 *             {
 *                 "AzureBackup_secondary",
 *             },
 *             PrivateEndpoint = new AzureNative.RecoveryServices.Inputs.PrivateEndpointArgs
 *             {
 *                 Id = "/subscriptions/04cf684a-d41f-4550-9f70-7708a3a2283b/resourceGroups/gaallaRG/providers/Microsoft.Network/privateEndpoints/gaallatestpe3",
 *             },
 *             PrivateLinkServiceConnectionState = new AzureNative.RecoveryServices.Inputs.PrivateLinkServiceConnectionStateArgs
 *             {
 *                 Description = "Approved by johndoe@company.com",
 *                 Status = "Approved",
 *             },
 *             ProvisioningState = "Succeeded",
 *         },
 *         ResourceGroupName = "gaallaRG",
 *         VaultName = "gaallavaultbvtd2msi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &recoveryservices.PrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("gaallatestpe2.5704c932-249a-490b-a142-1396838cd3b"),
 * 			Properties: recoveryservices.PrivateEndpointConnectionResponse{
 * 				GroupIds: pulumi.StringArray{
 * 					pulumi.String("AzureBackup_secondary"),
 * 				},
 * 				PrivateEndpoint: &recoveryservices.PrivateEndpointArgs{
 * 					Id: pulumi.String("/subscriptions/04cf684a-d41f-4550-9f70-7708a3a2283b/resourceGroups/gaallaRG/providers/Microsoft.Network/privateEndpoints/gaallatestpe3"),
 * 				},
 * 				PrivateLinkServiceConnectionState: &recoveryservices.PrivateLinkServiceConnectionStateArgs{
 * 					Description: pulumi.String("Approved by johndoe@company.com"),
 * 					Status:      pulumi.String("Approved"),
 * 				},
 * 				ProvisioningState: pulumi.String("Succeeded"),
 * 			},
 * 			ResourceGroupName: pulumi.String("gaallaRG"),
 * 			VaultName:         pulumi.String("gaallavaultbvtd2msi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.PrivateEndpointConnection;
 * import com.pulumi.azurenative.recoveryservices.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("gaallatestpe2.5704c932-249a-490b-a142-1396838cd3b")
 *             .properties(Map.ofEntries(
 *                 Map.entry("groupIds", "AzureBackup_secondary"),
 *                 Map.entry("privateEndpoint", Map.of("id", "/subscriptions/04cf684a-d41f-4550-9f70-7708a3a2283b/resourceGroups/gaallaRG/providers/Microsoft.Network/privateEndpoints/gaallatestpe3")),
 *                 Map.entry("privateLinkServiceConnectionState", Map.ofEntries(
 *                     Map.entry("description", "Approved by johndoe@company.com"),
 *                     Map.entry("status", "Approved")
 *                 )),
 *                 Map.entry("provisioningState", "Succeeded")
 *             ))
 *             .resourceGroupName("gaallaRG")
 *             .vaultName("gaallavaultbvtd2msi")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:PrivateEndpointConnection gaallatestpe1.3592346090307038890.backup.5704c932-249a-490b-a142-1396838cd3b /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property eTag Optional ETag.
 * @property location Resource location.
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property properties PrivateEndpointConnectionResource properties
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property tags Resource tags.
 * @property vaultName The name of the recovery services vault.
 */
public data class PrivateEndpointConnectionArgs(
    public val eTag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val properties:
    Output<com.pulumi.azurenative.recoveryservices.kotlin.inputs.PrivateEndpointConnectionArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.recoveryservices.PrivateEndpointConnectionArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var location: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var properties:
        Output<com.pulumi.azurenative.recoveryservices.kotlin.inputs.PrivateEndpointConnectionArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Optional ETag.
     */
    @JvmName("twoqacrowadudpby")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hyeoqjeftjtyxhlg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("thbkjeblkmxekoqk")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value PrivateEndpointConnectionResource properties
     */
    @JvmName("lldhsgtmwuxetcpj")
    public suspend
    fun properties(`value`: Output<com.pulumi.azurenative.recoveryservices.kotlin.inputs.PrivateEndpointConnectionArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("ayjnkeeqnkmoratd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qkesglmufihgiirn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("klevrjvdvqtnvdfs")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Optional ETag.
     */
    @JvmName("elojxjvkfujlnqlw")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("kunalyqrolsuhkdv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("xhmnknyxawhxksfp")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value PrivateEndpointConnectionResource properties
     */
    @JvmName("ifcmyyxpmswaeuxq")
    public suspend
    fun properties(`value`: com.pulumi.azurenative.recoveryservices.kotlin.inputs.PrivateEndpointConnectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument PrivateEndpointConnectionResource properties
     */
    @JvmName("xddikhkkiuoitrgf")
    public suspend
    fun properties(argument: suspend com.pulumi.azurenative.recoveryservices.kotlin.inputs.PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.recoveryservices.kotlin.inputs.PrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("mxvaaiwajumkgguf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qghattcktycrgecb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wiucytaflurlpoan")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("ngbifdkueqecjvjk")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        eTag = eTag,
        location = location,
        privateEndpointConnectionName = privateEndpointConnectionName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vaultName = vaultName,
    )
}
