@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ProtectedItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Base class for backup items.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2016-06-01, 2023-06-01.
 * ## Example Usage
 * ### Enable Protection on Azure IaasVm
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectedItem = new AzureNative.RecoveryServices.ProtectedItem("protectedItem", new()
 *     {
 *         ContainerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1",
 *         FabricName = "Azure",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSComputeVMProtectedItemArgs
 *         {
 *             PolicyId = "/Subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/DefaultPolicy",
 *             ProtectedItemType = "Microsoft.Compute/virtualMachines",
 *             SourceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1",
 *         },
 *         ProtectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1",
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectedItem(ctx, "protectedItem", &recoveryservices.ProtectedItemArgs{
 * 			ContainerName: pulumi.String("IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
 * 			FabricName:    pulumi.String("Azure"),
 * 			Properties: recoveryservices.AzureIaaSComputeVMProtectedItem{
 * 				PolicyId:          "/Subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/DefaultPolicy",
 * 				ProtectedItemType: "Microsoft.Compute/virtualMachines",
 * 				SourceResourceId:  "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1",
 * 			},
 * 			ProtectedItemName: pulumi.String("VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectedItem;
 * import com.pulumi.azurenative.recoveryservices.ProtectedItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectedItem = new ProtectedItem("protectedItem", ProtectedItemArgs.builder()
 *             .containerName("IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1")
 *             .fabricName("Azure")
 *             .properties(Map.ofEntries(
 *                 Map.entry("policyId", "/Subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/DefaultPolicy"),
 *                 Map.entry("protectedItemType", "Microsoft.Compute/virtualMachines"),
 *                 Map.entry("sourceResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1")
 *             ))
 *             .protectedItemName("VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1")
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ### Stop Protection with retain data on Azure IaasVm
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectedItem = new AzureNative.RecoveryServices.ProtectedItem("protectedItem", new()
 *     {
 *         ContainerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1",
 *         FabricName = "Azure",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSComputeVMProtectedItemArgs
 *         {
 *             ProtectedItemType = "Microsoft.Compute/virtualMachines",
 *             ProtectionState = "ProtectionStopped",
 *             SourceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1",
 *         },
 *         ProtectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1",
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectedItem(ctx, "protectedItem", &recoveryservices.ProtectedItemArgs{
 * 			ContainerName: pulumi.String("IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
 * 			FabricName:    pulumi.String("Azure"),
 * 			Properties: recoveryservices.AzureIaaSComputeVMProtectedItem{
 * 				ProtectedItemType: "Microsoft.Compute/virtualMachines",
 * 				ProtectionState:   "ProtectionStopped",
 * 				SourceResourceId:  "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1",
 * 			},
 * 			ProtectedItemName: pulumi.String("VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectedItem;
 * import com.pulumi.azurenative.recoveryservices.ProtectedItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectedItem = new ProtectedItem("protectedItem", ProtectedItemArgs.builder()
 *             .containerName("IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1")
 *             .fabricName("Azure")
 *             .properties(Map.ofEntries(
 *                 Map.entry("protectedItemType", "Microsoft.Compute/virtualMachines"),
 *                 Map.entry("protectionState", "ProtectionStopped"),
 *                 Map.entry("sourceResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1")
 *             ))
 *             .protectedItemName("VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1")
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ProtectedItem VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}
 * ```
 * @property containerName Container name associated with the backup item.
 * @property eTag Optional ETag.
 * @property fabricName Fabric name associated with the backup item.
 * @property location Resource location.
 * @property properties ProtectedItemResource properties
 * @property protectedItemName Item name to be backed up.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property tags Resource tags.
 * @property vaultName The name of the recovery services vault.
 */
public data class ProtectedItemArgs(
    public val containerName: Output<String>? = null,
    public val eTag: Output<String>? = null,
    public val fabricName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val protectedItemName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ProtectedItemArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ProtectedItemArgs =
        com.pulumi.azurenative.recoveryservices.ProtectedItemArgs.builder()
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .protectedItemName(protectedItemName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProtectedItemArgs].
 */
@PulumiTagMarker
public class ProtectedItemArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var eTag: Output<String>? = null

    private var fabricName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<Any>? = null

    private var protectedItemName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Container name associated with the backup item.
     */
    @JvmName("byxtqsuwrhigyawc")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Optional ETag.
     */
    @JvmName("qpbakhqmydcqqpxp")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Fabric name associated with the backup item.
     */
    @JvmName("klrbvjtdbvgodbvq")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("jnirfyexmdnhfoiq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ProtectedItemResource properties
     */
    @JvmName("dttfmyorcsyyqsmk")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value Item name to be backed up.
     */
    @JvmName("jgbtftasbbstbilf")
    public suspend fun protectedItemName(`value`: Output<String>) {
        this.protectedItemName = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("atperemdwporiymb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gvxiyticscjukwns")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("piekhdmfujqoxpwl")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Container name associated with the backup item.
     */
    @JvmName("ypvihmeefvvtgimj")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Optional ETag.
     */
    @JvmName("iynhdmaopgyddrat")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Fabric name associated with the backup item.
     */
    @JvmName("cldonmnespwbnhix")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xivwdyxfsggqwuuy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ProtectedItemResource properties
     */
    @JvmName("omyptpokyfxhckbh")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Item name to be backed up.
     */
    @JvmName("jsexnpfjprueykff")
    public suspend fun protectedItemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("circppupvuqppxqr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("puaniekopntjueaa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("aliwskghccjoghvm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("fkbfoynomirfvopm")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): ProtectedItemArgs = ProtectedItemArgs(
        containerName = containerName,
        eTag = eTag,
        fabricName = fabricName,
        location = location,
        properties = properties,
        protectedItemName = protectedItemName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vaultName = vaultName,
    )
}
