@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getProtectedItemPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getProtectionContainerPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getProtectionIntentPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getProtectionPolicyPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getRecoveryPointAccessTokenPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getReplicationFabricPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getReplicationMigrationItemPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getReplicationNetworkMappingPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getReplicationPolicyPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getReplicationProtectedItemPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getReplicationProtectionContainerMappingPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getReplicationRecoveryPlanPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getReplicationRecoveryServicesProviderPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getReplicationStorageClassificationMappingPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getReplicationvCenterPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getResourceGuardProxyPlain
import com.pulumi.azurenative.recoveryservices.RecoveryservicesFunctions.getVaultPlain
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.AADProperties
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetProtectedItemPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetProtectedItemPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetProtectionContainerPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetProtectionContainerPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetProtectionIntentPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetProtectionIntentPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetProtectionPolicyPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetProtectionPolicyPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetRecoveryPointAccessTokenPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetRecoveryPointAccessTokenPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationFabricPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationFabricPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationMigrationItemPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationMigrationItemPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationNetworkMappingPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationNetworkMappingPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationPolicyPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationPolicyPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationProtectedItemPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationProtectedItemPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationProtectionContainerMappingPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationProtectionContainerMappingPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationRecoveryPlanPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationRecoveryPlanPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationRecoveryServicesProviderPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationRecoveryServicesProviderPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationStorageClassificationMappingPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationStorageClassificationMappingPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationvCenterPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetReplicationvCenterPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetResourceGuardProxyPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetResourceGuardProxyPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetVaultPlainArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.GetVaultPlainArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetProtectedItemResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetProtectionContainerResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetProtectionIntentResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetProtectionPolicyResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetRecoveryPointAccessTokenResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationFabricResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationMigrationItemResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationNetworkMappingResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationPolicyResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationProtectedItemResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationProtectionContainerMappingResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationRecoveryPlanResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationRecoveryServicesProviderResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationStorageClassificationMappingResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationvCenterResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetResourceGuardProxyResult
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetVaultResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetProtectedItemResult.Companion.toKotlin as getProtectedItemResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetProtectionContainerResult.Companion.toKotlin as getProtectionContainerResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetProtectionIntentResult.Companion.toKotlin as getProtectionIntentResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetProtectionPolicyResult.Companion.toKotlin as getProtectionPolicyResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetRecoveryPointAccessTokenResult.Companion.toKotlin as getRecoveryPointAccessTokenResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationFabricResult.Companion.toKotlin as getReplicationFabricResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationMigrationItemResult.Companion.toKotlin as getReplicationMigrationItemResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationNetworkMappingResult.Companion.toKotlin as getReplicationNetworkMappingResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationPolicyResult.Companion.toKotlin as getReplicationPolicyResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationProtectedItemResult.Companion.toKotlin as getReplicationProtectedItemResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationProtectionContainerMappingResult.Companion.toKotlin as getReplicationProtectionContainerMappingResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationRecoveryPlanResult.Companion.toKotlin as getReplicationRecoveryPlanResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationRecoveryServicesProviderResult.Companion.toKotlin as getReplicationRecoveryServicesProviderResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationStorageClassificationMappingResult.Companion.toKotlin as getReplicationStorageClassificationMappingResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetReplicationvCenterResult.Companion.toKotlin as getReplicationvCenterResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetResourceGuardProxyResult.Companion.toKotlin as getResourceGuardProxyResultToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.GetVaultResult.Companion.toKotlin as getVaultResultToKotlin

public object RecoveryservicesFunctions {
    /**
     * Get Private Endpoint Connection. This call is made by Backup Admin.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return Private Endpoint Connection Response Properties
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param vaultName The name of the recovery services vault.
     * @return Private Endpoint Connection Response Properties
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return Private Endpoint Connection Response Properties
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides the details of the backed up item. This is an asynchronous operation. To know the status of the operation,
     * call the GetItemOperationResult API.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2016-06-01, 2023-06-01.
     * @param argument null
     * @return Base class for backup items.
     */
    public suspend fun getProtectedItem(argument: GetProtectedItemPlainArgs): GetProtectedItemResult =
        getProtectedItemResultToKotlin(getProtectedItemPlain(argument.toJava()).await())

    /**
     * @see [getProtectedItem].
     * @param containerName Container name associated with the backed up item.
     * @param fabricName Fabric name associated with the backed up item.
     * @param filter OData filter options.
     * @param protectedItemName Backed up item name whose details are to be fetched.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param vaultName The name of the recovery services vault.
     * @return Base class for backup items.
     */
    public suspend fun getProtectedItem(
        containerName: String,
        fabricName: String,
        filter: String? = null,
        protectedItemName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetProtectedItemResult {
        val argument = GetProtectedItemPlainArgs(
            containerName = containerName,
            fabricName = fabricName,
            filter = filter,
            protectedItemName = protectedItemName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getProtectedItemResultToKotlin(getProtectedItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getProtectedItem].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetProtectedItemPlainArgs].
     * @return Base class for backup items.
     */
    public suspend
    fun getProtectedItem(argument: suspend GetProtectedItemPlainArgsBuilder.() -> Unit):
        GetProtectedItemResult {
        val builder = GetProtectedItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProtectedItemResultToKotlin(getProtectedItemPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets details of the specific container registered to your Recovery Services Vault.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return Base class for container with backup items. Containers with specific workloads are derived from this class.
     */
    public suspend fun getProtectionContainer(argument: GetProtectionContainerPlainArgs):
        GetProtectionContainerResult =
        getProtectionContainerResultToKotlin(getProtectionContainerPlain(argument.toJava()).await())

    /**
     * @see [getProtectionContainer].
     * @param containerName Name of the container whose details need to be fetched.
     * @param fabricName Name of the fabric where the container belongs.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param vaultName The name of the recovery services vault.
     * @return Base class for container with backup items. Containers with specific workloads are derived from this class.
     */
    public suspend fun getProtectionContainer(
        containerName: String,
        fabricName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetProtectionContainerResult {
        val argument = GetProtectionContainerPlainArgs(
            containerName = containerName,
            fabricName = fabricName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getProtectionContainerResultToKotlin(getProtectionContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getProtectionContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetProtectionContainerPlainArgs].
     * @return Base class for container with backup items. Containers with specific workloads are derived from this class.
     */
    public suspend
    fun getProtectionContainer(argument: suspend GetProtectionContainerPlainArgsBuilder.() -> Unit):
        GetProtectionContainerResult {
        val builder = GetProtectionContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProtectionContainerResultToKotlin(getProtectionContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides the details of the protection intent up item. This is an asynchronous operation. To know the status of the operation,
     * call the GetItemOperationResult API.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return Base class for backup ProtectionIntent.
     */
    public suspend fun getProtectionIntent(argument: GetProtectionIntentPlainArgs):
        GetProtectionIntentResult =
        getProtectionIntentResultToKotlin(getProtectionIntentPlain(argument.toJava()).await())

    /**
     * @see [getProtectionIntent].
     * @param fabricName Fabric name associated with the backed up item.
     * @param intentObjectName Backed up item name whose details are to be fetched.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param vaultName The name of the recovery services vault.
     * @return Base class for backup ProtectionIntent.
     */
    public suspend fun getProtectionIntent(
        fabricName: String,
        intentObjectName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetProtectionIntentResult {
        val argument = GetProtectionIntentPlainArgs(
            fabricName = fabricName,
            intentObjectName = intentObjectName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getProtectionIntentResultToKotlin(getProtectionIntentPlain(argument.toJava()).await())
    }

    /**
     * @see [getProtectionIntent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetProtectionIntentPlainArgs].
     * @return Base class for backup ProtectionIntent.
     */
    public suspend
    fun getProtectionIntent(argument: suspend GetProtectionIntentPlainArgsBuilder.() -> Unit):
        GetProtectionIntentResult {
        val builder = GetProtectionIntentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProtectionIntentResultToKotlin(getProtectionIntentPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides the details of the backup policies associated to Recovery Services Vault. This is an asynchronous
     * operation. Status of the operation can be fetched using GetPolicyOperationResult API.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2016-06-01, 2023-06-01.
     * @param argument null
     * @return Base class for backup policy. Workload-specific backup policies are derived from this class.
     */
    public suspend fun getProtectionPolicy(argument: GetProtectionPolicyPlainArgs):
        GetProtectionPolicyResult =
        getProtectionPolicyResultToKotlin(getProtectionPolicyPlain(argument.toJava()).await())

    /**
     * @see [getProtectionPolicy].
     * @param policyName Backup policy information to be fetched.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param vaultName The name of the recovery services vault.
     * @return Base class for backup policy. Workload-specific backup policies are derived from this class.
     */
    public suspend fun getProtectionPolicy(
        policyName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetProtectionPolicyResult {
        val argument = GetProtectionPolicyPlainArgs(
            policyName = policyName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getProtectionPolicyResultToKotlin(getProtectionPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getProtectionPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetProtectionPolicyPlainArgs].
     * @return Base class for backup policy. Workload-specific backup policies are derived from this class.
     */
    public suspend
    fun getProtectionPolicy(argument: suspend GetProtectionPolicyPlainArgsBuilder.() -> Unit):
        GetProtectionPolicyResult {
        val builder = GetProtectionPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProtectionPolicyResultToKotlin(getProtectionPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-01-15.
     * Other available API versions: 2018-12-20, 2021-11-15.
     * @param argument null
     * @return null
     */
    public suspend fun getRecoveryPointAccessToken(argument: GetRecoveryPointAccessTokenPlainArgs):
        GetRecoveryPointAccessTokenResult =
        getRecoveryPointAccessTokenResultToKotlin(getRecoveryPointAccessTokenPlain(argument.toJava()).await())

    /**
     * @see [getRecoveryPointAccessToken].
     * @param containerName Name of the container.
     * @param eTag Optional ETag.
     * @param fabricName Fabric name associated with the container.
     * @param location Resource location.
     * @param properties AADPropertiesResource properties
     * @param protectedItemName Name of the Protected Item.
     * @param recoveryPointId Recovery Point Id
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param tags Resource tags.
     * @param vaultName The name of the recovery services vault.
     * @return null
     */
    public suspend fun getRecoveryPointAccessToken(
        containerName: String,
        eTag: String? = null,
        fabricName: String,
        location: String? = null,
        properties: AADProperties? = null,
        protectedItemName: String,
        recoveryPointId: String,
        resourceGroupName: String,
        tags: Map<String, String>? = null,
        vaultName: String,
    ): GetRecoveryPointAccessTokenResult {
        val argument = GetRecoveryPointAccessTokenPlainArgs(
            containerName = containerName,
            eTag = eTag,
            fabricName = fabricName,
            location = location,
            properties = properties,
            protectedItemName = protectedItemName,
            recoveryPointId = recoveryPointId,
            resourceGroupName = resourceGroupName,
            tags = tags,
            vaultName = vaultName,
        )
        return getRecoveryPointAccessTokenResultToKotlin(getRecoveryPointAccessTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getRecoveryPointAccessToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetRecoveryPointAccessTokenPlainArgs].
     * @return null
     */
    public suspend
    fun getRecoveryPointAccessToken(argument: suspend GetRecoveryPointAccessTokenPlainArgsBuilder.() -> Unit):
        GetRecoveryPointAccessTokenResult {
        val builder = GetRecoveryPointAccessTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRecoveryPointAccessTokenResultToKotlin(getRecoveryPointAccessTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of an Azure Site Recovery fabric.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return Fabric definition.
     */
    public suspend fun getReplicationFabric(argument: GetReplicationFabricPlainArgs):
        GetReplicationFabricResult =
        getReplicationFabricResultToKotlin(getReplicationFabricPlain(argument.toJava()).await())

    /**
     * @see [getReplicationFabric].
     * @param fabricName Fabric name.
     * @param filter OData filter options.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param resourceName The name of the recovery services vault.
     * @return Fabric definition.
     */
    public suspend fun getReplicationFabric(
        fabricName: String,
        filter: String? = null,
        resourceGroupName: String,
        resourceName: String,
    ): GetReplicationFabricResult {
        val argument = GetReplicationFabricPlainArgs(
            fabricName = fabricName,
            filter = filter,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getReplicationFabricResultToKotlin(getReplicationFabricPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationFabric].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetReplicationFabricPlainArgs].
     * @return Fabric definition.
     */
    public suspend
    fun getReplicationFabric(argument: suspend GetReplicationFabricPlainArgsBuilder.() -> Unit):
        GetReplicationFabricResult {
        val builder = GetReplicationFabricPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationFabricResultToKotlin(getReplicationFabricPlain(builtArgument.toJava()).await())
    }

    /**
     * Migration item.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return Migration item.
     */
    public suspend fun getReplicationMigrationItem(argument: GetReplicationMigrationItemPlainArgs):
        GetReplicationMigrationItemResult =
        getReplicationMigrationItemResultToKotlin(getReplicationMigrationItemPlain(argument.toJava()).await())

    /**
     * @see [getReplicationMigrationItem].
     * @param fabricName Fabric unique name.
     * @param migrationItemName Migration item name.
     * @param protectionContainerName Protection container name.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param resourceName The name of the recovery services vault.
     * @return Migration item.
     */
    public suspend fun getReplicationMigrationItem(
        fabricName: String,
        migrationItemName: String,
        protectionContainerName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetReplicationMigrationItemResult {
        val argument = GetReplicationMigrationItemPlainArgs(
            fabricName = fabricName,
            migrationItemName = migrationItemName,
            protectionContainerName = protectionContainerName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getReplicationMigrationItemResultToKotlin(getReplicationMigrationItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationMigrationItem].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetReplicationMigrationItemPlainArgs].
     * @return Migration item.
     */
    public suspend
    fun getReplicationMigrationItem(argument: suspend GetReplicationMigrationItemPlainArgsBuilder.() -> Unit):
        GetReplicationMigrationItemResult {
        val builder = GetReplicationMigrationItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationMigrationItemResultToKotlin(getReplicationMigrationItemPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of an ASR network mapping.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01, 2023-06-01.
     * @param argument null
     * @return Network Mapping model. Ideally it should have been possible to inherit this class from prev version in InheritedModels as long as there is no difference in structure or method signature. Since there were no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the class has been introduced in its entirety with references to base models to facilitate extensions in subsequent versions.
     */
    public suspend fun getReplicationNetworkMapping(argument: GetReplicationNetworkMappingPlainArgs):
        GetReplicationNetworkMappingResult =
        getReplicationNetworkMappingResultToKotlin(getReplicationNetworkMappingPlain(argument.toJava()).await())

    /**
     * @see [getReplicationNetworkMapping].
     * @param fabricName Primary fabric name.
     * @param networkMappingName Network mapping name.
     * @param networkName Primary network name.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param resourceName The name of the recovery services vault.
     * @return Network Mapping model. Ideally it should have been possible to inherit this class from prev version in InheritedModels as long as there is no difference in structure or method signature. Since there were no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the class has been introduced in its entirety with references to base models to facilitate extensions in subsequent versions.
     */
    public suspend fun getReplicationNetworkMapping(
        fabricName: String,
        networkMappingName: String,
        networkName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetReplicationNetworkMappingResult {
        val argument = GetReplicationNetworkMappingPlainArgs(
            fabricName = fabricName,
            networkMappingName = networkMappingName,
            networkName = networkName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getReplicationNetworkMappingResultToKotlin(getReplicationNetworkMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationNetworkMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetReplicationNetworkMappingPlainArgs].
     * @return Network Mapping model. Ideally it should have been possible to inherit this class from prev version in InheritedModels as long as there is no difference in structure or method signature. Since there were no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the class has been introduced in its entirety with references to base models to facilitate extensions in subsequent versions.
     */
    public suspend
    fun getReplicationNetworkMapping(argument: suspend GetReplicationNetworkMappingPlainArgsBuilder.() -> Unit):
        GetReplicationNetworkMappingResult {
        val builder = GetReplicationNetworkMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationNetworkMappingResultToKotlin(getReplicationNetworkMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of a replication policy.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return Protection profile details.
     */
    public suspend fun getReplicationPolicy(argument: GetReplicationPolicyPlainArgs):
        GetReplicationPolicyResult =
        getReplicationPolicyResultToKotlin(getReplicationPolicyPlain(argument.toJava()).await())

    /**
     * @see [getReplicationPolicy].
     * @param policyName Replication policy name.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param resourceName The name of the recovery services vault.
     * @return Protection profile details.
     */
    public suspend fun getReplicationPolicy(
        policyName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetReplicationPolicyResult {
        val argument = GetReplicationPolicyPlainArgs(
            policyName = policyName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getReplicationPolicyResultToKotlin(getReplicationPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetReplicationPolicyPlainArgs].
     * @return Protection profile details.
     */
    public suspend
    fun getReplicationPolicy(argument: suspend GetReplicationPolicyPlainArgsBuilder.() -> Unit):
        GetReplicationPolicyResult {
        val builder = GetReplicationPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationPolicyResultToKotlin(getReplicationPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of an ASR replication protected item.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return Replication protected item.
     */
    public suspend fun getReplicationProtectedItem(argument: GetReplicationProtectedItemPlainArgs):
        GetReplicationProtectedItemResult =
        getReplicationProtectedItemResultToKotlin(getReplicationProtectedItemPlain(argument.toJava()).await())

    /**
     * @see [getReplicationProtectedItem].
     * @param fabricName Fabric unique name.
     * @param protectionContainerName Protection container name.
     * @param replicatedProtectedItemName Replication protected item name.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param resourceName The name of the recovery services vault.
     * @return Replication protected item.
     */
    public suspend fun getReplicationProtectedItem(
        fabricName: String,
        protectionContainerName: String,
        replicatedProtectedItemName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetReplicationProtectedItemResult {
        val argument = GetReplicationProtectedItemPlainArgs(
            fabricName = fabricName,
            protectionContainerName = protectionContainerName,
            replicatedProtectedItemName = replicatedProtectedItemName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getReplicationProtectedItemResultToKotlin(getReplicationProtectedItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationProtectedItem].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetReplicationProtectedItemPlainArgs].
     * @return Replication protected item.
     */
    public suspend
    fun getReplicationProtectedItem(argument: suspend GetReplicationProtectedItemPlainArgsBuilder.() -> Unit):
        GetReplicationProtectedItemResult {
        val builder = GetReplicationProtectedItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationProtectedItemResultToKotlin(getReplicationProtectedItemPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of a protection container mapping.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return Protection container mapping object.
     */
    public suspend
    fun getReplicationProtectionContainerMapping(argument: GetReplicationProtectionContainerMappingPlainArgs):
        GetReplicationProtectionContainerMappingResult =
        getReplicationProtectionContainerMappingResultToKotlin(getReplicationProtectionContainerMappingPlain(argument.toJava()).await())

    /**
     * @see [getReplicationProtectionContainerMapping].
     * @param fabricName Fabric name.
     * @param mappingName Protection Container mapping name.
     * @param protectionContainerName Protection container name.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param resourceName The name of the recovery services vault.
     * @return Protection container mapping object.
     */
    public suspend fun getReplicationProtectionContainerMapping(
        fabricName: String,
        mappingName: String,
        protectionContainerName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetReplicationProtectionContainerMappingResult {
        val argument = GetReplicationProtectionContainerMappingPlainArgs(
            fabricName = fabricName,
            mappingName = mappingName,
            protectionContainerName = protectionContainerName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getReplicationProtectionContainerMappingResultToKotlin(getReplicationProtectionContainerMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationProtectionContainerMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetReplicationProtectionContainerMappingPlainArgs].
     * @return Protection container mapping object.
     */
    public suspend
    fun getReplicationProtectionContainerMapping(argument: suspend GetReplicationProtectionContainerMappingPlainArgsBuilder.() -> Unit):
        GetReplicationProtectionContainerMappingResult {
        val builder = GetReplicationProtectionContainerMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationProtectionContainerMappingResultToKotlin(getReplicationProtectionContainerMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the recovery plan.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return Recovery plan details.
     */
    public suspend fun getReplicationRecoveryPlan(argument: GetReplicationRecoveryPlanPlainArgs):
        GetReplicationRecoveryPlanResult =
        getReplicationRecoveryPlanResultToKotlin(getReplicationRecoveryPlanPlain(argument.toJava()).await())

    /**
     * @see [getReplicationRecoveryPlan].
     * @param recoveryPlanName Name of the recovery plan.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param resourceName The name of the recovery services vault.
     * @return Recovery plan details.
     */
    public suspend fun getReplicationRecoveryPlan(
        recoveryPlanName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetReplicationRecoveryPlanResult {
        val argument = GetReplicationRecoveryPlanPlainArgs(
            recoveryPlanName = recoveryPlanName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getReplicationRecoveryPlanResultToKotlin(getReplicationRecoveryPlanPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationRecoveryPlan].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetReplicationRecoveryPlanPlainArgs].
     * @return Recovery plan details.
     */
    public suspend
    fun getReplicationRecoveryPlan(argument: suspend GetReplicationRecoveryPlanPlainArgsBuilder.() -> Unit):
        GetReplicationRecoveryPlanResult {
        val builder = GetReplicationRecoveryPlanPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationRecoveryPlanResultToKotlin(getReplicationRecoveryPlanPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of registered recovery services provider.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return Provider details.
     */
    public suspend
    fun getReplicationRecoveryServicesProvider(argument: GetReplicationRecoveryServicesProviderPlainArgs):
        GetReplicationRecoveryServicesProviderResult =
        getReplicationRecoveryServicesProviderResultToKotlin(getReplicationRecoveryServicesProviderPlain(argument.toJava()).await())

    /**
     * @see [getReplicationRecoveryServicesProvider].
     * @param fabricName Fabric name.
     * @param providerName Recovery services provider name.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param resourceName The name of the recovery services vault.
     * @return Provider details.
     */
    public suspend fun getReplicationRecoveryServicesProvider(
        fabricName: String,
        providerName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetReplicationRecoveryServicesProviderResult {
        val argument = GetReplicationRecoveryServicesProviderPlainArgs(
            fabricName = fabricName,
            providerName = providerName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getReplicationRecoveryServicesProviderResultToKotlin(getReplicationRecoveryServicesProviderPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationRecoveryServicesProvider].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetReplicationRecoveryServicesProviderPlainArgs].
     * @return Provider details.
     */
    public suspend
    fun getReplicationRecoveryServicesProvider(argument: suspend GetReplicationRecoveryServicesProviderPlainArgsBuilder.() -> Unit):
        GetReplicationRecoveryServicesProviderResult {
        val builder = GetReplicationRecoveryServicesProviderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationRecoveryServicesProviderResultToKotlin(getReplicationRecoveryServicesProviderPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the specified storage classification mapping.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return Storage mapping object.
     */
    public suspend
    fun getReplicationStorageClassificationMapping(argument: GetReplicationStorageClassificationMappingPlainArgs):
        GetReplicationStorageClassificationMappingResult =
        getReplicationStorageClassificationMappingResultToKotlin(getReplicationStorageClassificationMappingPlain(argument.toJava()).await())

    /**
     * @see [getReplicationStorageClassificationMapping].
     * @param fabricName Fabric name.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param resourceName The name of the recovery services vault.
     * @param storageClassificationMappingName Storage classification mapping name.
     * @param storageClassificationName Storage classification name.
     * @return Storage mapping object.
     */
    public suspend fun getReplicationStorageClassificationMapping(
        fabricName: String,
        resourceGroupName: String,
        resourceName: String,
        storageClassificationMappingName: String,
        storageClassificationName: String,
    ): GetReplicationStorageClassificationMappingResult {
        val argument = GetReplicationStorageClassificationMappingPlainArgs(
            fabricName = fabricName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            storageClassificationMappingName = storageClassificationMappingName,
            storageClassificationName = storageClassificationName,
        )
        return getReplicationStorageClassificationMappingResultToKotlin(getReplicationStorageClassificationMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationStorageClassificationMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetReplicationStorageClassificationMappingPlainArgs].
     * @return Storage mapping object.
     */
    public suspend
    fun getReplicationStorageClassificationMapping(argument: suspend GetReplicationStorageClassificationMappingPlainArgsBuilder.() -> Unit):
        GetReplicationStorageClassificationMappingResult {
        val builder = GetReplicationStorageClassificationMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationStorageClassificationMappingResultToKotlin(getReplicationStorageClassificationMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of a registered vCenter server(Add vCenter server).
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01, 2023-06-01.
     * @param argument null
     * @return vCenter definition.
     */
    public suspend fun getReplicationvCenter(argument: GetReplicationvCenterPlainArgs):
        GetReplicationvCenterResult =
        getReplicationvCenterResultToKotlin(getReplicationvCenterPlain(argument.toJava()).await())

    /**
     * @see [getReplicationvCenter].
     * @param fabricName Fabric name.
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param resourceName The name of the recovery services vault.
     * @param vcenterName vcenter name.
     * @return vCenter definition.
     */
    public suspend fun getReplicationvCenter(
        fabricName: String,
        resourceGroupName: String,
        resourceName: String,
        vcenterName: String,
    ): GetReplicationvCenterResult {
        val argument = GetReplicationvCenterPlainArgs(
            fabricName = fabricName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            vcenterName = vcenterName,
        )
        return getReplicationvCenterResultToKotlin(getReplicationvCenterPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationvCenter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetReplicationvCenterPlainArgs].
     * @return vCenter definition.
     */
    public suspend
    fun getReplicationvCenter(argument: suspend GetReplicationvCenterPlainArgsBuilder.() -> Unit):
        GetReplicationvCenterResult {
        val builder = GetReplicationvCenterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationvCenterResultToKotlin(getReplicationvCenterPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns ResourceGuardProxy under vault and with the name referenced in request
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-06-01.
     * @param argument null
     * @return null
     */
    public suspend fun getResourceGuardProxy(argument: GetResourceGuardProxyPlainArgs):
        GetResourceGuardProxyResult =
        getResourceGuardProxyResultToKotlin(getResourceGuardProxyPlain(argument.toJava()).await())

    /**
     * @see [getResourceGuardProxy].
     * @param resourceGroupName The name of the resource group where the recovery services vault is present.
     * @param resourceGuardProxyName
     * @param vaultName The name of the recovery services vault.
     * @return null
     */
    public suspend fun getResourceGuardProxy(
        resourceGroupName: String,
        resourceGuardProxyName: String,
        vaultName: String,
    ): GetResourceGuardProxyResult {
        val argument = GetResourceGuardProxyPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceGuardProxyName = resourceGuardProxyName,
            vaultName = vaultName,
        )
        return getResourceGuardProxyResultToKotlin(getResourceGuardProxyPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceGuardProxy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetResourceGuardProxyPlainArgs].
     * @return null
     */
    public suspend
    fun getResourceGuardProxy(argument: suspend GetResourceGuardProxyPlainArgsBuilder.() -> Unit):
        GetResourceGuardProxyResult {
        val builder = GetResourceGuardProxyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceGuardProxyResultToKotlin(getResourceGuardProxyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Vault details.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2020-02-02, 2023-06-01.
     * @param argument null
     * @return Resource information, as returned by the resource provider.
     */
    public suspend fun getVault(argument: GetVaultPlainArgs): GetVaultResult =
        getVaultResultToKotlin(getVaultPlain(argument.toJava()).await())

    /**
     * @see [getVault].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the recovery services vault.
     * @return Resource information, as returned by the resource provider.
     */
    public suspend fun getVault(resourceGroupName: String, vaultName: String): GetVaultResult {
        val argument = GetVaultPlainArgs(
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getVaultResultToKotlin(getVaultPlain(argument.toJava()).await())
    }

    /**
     * @see [getVault].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recoveryservices&#46;kotlin&#46;inputs&#46;GetVaultPlainArgs].
     * @return Resource information, as returned by the resource provider.
     */
    public suspend fun getVault(argument: suspend GetVaultPlainArgsBuilder.() -> Unit):
        GetVaultResult {
        val builder = GetVaultPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVaultResultToKotlin(getVaultPlain(builtArgument.toJava()).await())
    }
}
