@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.PolicyPropertiesResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.PolicyPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationPolicy].
 */
@PulumiTagMarker
public class ReplicationPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationPolicyArgs = ReplicationPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationPolicyArgsBuilder.() -> Unit) {
        val builder = ReplicationPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ReplicationPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationPolicy(builtJavaResource)
    }
}

/**
 * Protection profile details.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01.
 * ## Example Usage
 * ### Creates the policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationPolicy = new AzureNative.RecoveryServices.ReplicationPolicy("replicationPolicy", new()
 *     {
 *         PolicyName = "protectionprofile1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.CreatePolicyInputPropertiesArgs
 *         {
 *             ProviderSpecificInput = new AzureNative.RecoveryServices.Inputs.HyperVReplicaAzurePolicyInputArgs
 *             {
 *                 InstanceType = "HyperVReplicaAzure",
 *             },
 *         },
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := recoveryservices.NewReplicationPolicy(ctx, "replicationPolicy", &recoveryservices.ReplicationPolicyArgs{
 * PolicyName: pulumi.String("protectionprofile1"),
 * Properties: interface{}{
 * ProviderSpecificInput: recoveryservices.HyperVReplicaAzurePolicyInput{
 * InstanceType: "HyperVReplicaAzure",
 * },
 * },
 * ResourceGroupName: pulumi.String("resourceGroupPS1"),
 * ResourceName: pulumi.String("vault1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationPolicy;
 * import com.pulumi.azurenative.recoveryservices.ReplicationPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationPolicy = new ReplicationPolicy("replicationPolicy", ReplicationPolicyArgs.builder()
 *             .policyName("protectionprofile1")
 *             .properties(Map.of("providerSpecificInput", Map.of("instanceType", "HyperVReplicaAzure")))
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationPolicy protectionprofile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationPolicies/{policyName}
 * ```
 */
public class ReplicationPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ReplicationPolicy,
) : KotlinCustomResource(javaResource, ReplicationPolicyMapper) {
    /**
     * Resource Location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The custom data.
     */
    public val properties: Output<PolicyPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationPolicyMapper : ResourceMapper<ReplicationPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ReplicationPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationPolicy = ReplicationPolicy(
        javaResource as
            com.pulumi.azurenative.recoveryservices.ReplicationPolicy,
    )
}

/**
 * @see [ReplicationPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationPolicy].
 */
public suspend fun replicationPolicy(
    name: String,
    block: suspend ReplicationPolicyResourceBuilder.() -> Unit,
): ReplicationPolicy {
    val builder = ReplicationPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationPolicy(name: String): ReplicationPolicy {
    val builder = ReplicationPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
