@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.ReplicationProtectedItemPropertiesResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.ReplicationProtectedItemPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationProtectedItem].
 */
@PulumiTagMarker
public class ReplicationProtectedItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationProtectedItemArgs = ReplicationProtectedItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationProtectedItemArgsBuilder.() -> Unit) {
        val builder = ReplicationProtectedItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationProtectedItem {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ReplicationProtectedItem(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationProtectedItem(builtJavaResource)
    }
}

/**
 * Replication protected item.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01.
 * ## Example Usage
 * ### Enables protection.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationProtectedItem = new AzureNative.RecoveryServices.ReplicationProtectedItem("replicationProtectedItem", new()
 *     {
 *         FabricName = "cloud1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.EnableProtectionInputPropertiesArgs
 *         {
 *             PolicyId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1",
 *             ProtectableItemId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectableItems/f8491e4f-817a-40dd-a90c-af773978c75b",
 *             ProviderSpecificDetails = new AzureNative.RecoveryServices.Inputs.HyperVReplicaAzureEnableProtectionInputArgs
 *             {
 *                 InstanceType = "HyperVReplicaAzure",
 *             },
 *         },
 *         ProtectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179",
 *         ReplicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b",
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := recoveryservices.NewReplicationProtectedItem(ctx, "replicationProtectedItem", &recoveryservices.ReplicationProtectedItemArgs{
 * FabricName: pulumi.String("cloud1"),
 * Properties: interface{}{
 * PolicyId: pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1"),
 * ProtectableItemId: pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectableItems/f8491e4f-817a-40dd-a90c-af773978c75b"),
 * ProviderSpecificDetails: recoveryservices.HyperVReplicaAzureEnableProtectionInput{
 * InstanceType: "HyperVReplicaAzure",
 * },
 * },
 * ProtectionContainerName: pulumi.String("cloud_6d224fc6-f326-5d35-96de-fbf51efb3179"),
 * ReplicatedProtectedItemName: pulumi.String("f8491e4f-817a-40dd-a90c-af773978c75b"),
 * ResourceGroupName: pulumi.String("resourceGroupPS1"),
 * ResourceName: pulumi.String("vault1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectedItem;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectedItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationProtectedItem = new ReplicationProtectedItem("replicationProtectedItem", ReplicationProtectedItemArgs.builder()
 *             .fabricName("cloud1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("policyId", "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1"),
 *                 Map.entry("protectableItemId", "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectableItems/f8491e4f-817a-40dd-a90c-af773978c75b"),
 *                 Map.entry("providerSpecificDetails", Map.of("instanceType", "HyperVReplicaAzure"))
 *             ))
 *             .protectionContainerName("cloud_6d224fc6-f326-5d35-96de-fbf51efb3179")
 *             .replicatedProtectedItemName("f8491e4f-817a-40dd-a90c-af773978c75b")
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationProtectedItem f8491e4f-817a-40dd-a90c-af773978c75b /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}
 * ```
 */
public class ReplicationProtectedItem internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ReplicationProtectedItem,
) : KotlinCustomResource(javaResource, ReplicationProtectedItemMapper) {
    /**
     * Resource Location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The custom data.
     */
    public val properties: Output<ReplicationProtectedItemPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationProtectedItemMapper : ResourceMapper<ReplicationProtectedItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ReplicationProtectedItem::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationProtectedItem =
        ReplicationProtectedItem(
            javaResource as
                com.pulumi.azurenative.recoveryservices.ReplicationProtectedItem,
        )
}

/**
 * @see [ReplicationProtectedItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationProtectedItem].
 */
public suspend fun replicationProtectedItem(
    name: String,
    block: suspend ReplicationProtectedItemResourceBuilder.() -> Unit,
): ReplicationProtectedItem {
    val builder = ReplicationProtectedItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationProtectedItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationProtectedItem(name: String): ReplicationProtectedItem {
    val builder = ReplicationProtectedItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
