@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlanArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.CreateRecoveryPlanInputPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.CreateRecoveryPlanInputPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Recovery plan details.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01.
 * ## Example Usage
 * ### Creates a recovery plan with the given details.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationRecoveryPlan = new AzureNative.RecoveryServices.ReplicationRecoveryPlan("replicationRecoveryPlan", new()
 *     {
 *         Properties = new AzureNative.RecoveryServices.Inputs.CreateRecoveryPlanInputPropertiesArgs
 *         {
 *             FailoverDeploymentModel = "ResourceManager",
 *             Groups = new[]
 *             {
 *                 new AzureNative.RecoveryServices.Inputs.RecoveryPlanGroupArgs
 *                 {
 *                     EndGroupActions = new[] {},
 *                     GroupType = "Boot",
 *                     ReplicationProtectedItems = new[]
 *                     {
 *                         new AzureNative.RecoveryServices.Inputs.RecoveryPlanProtectedItemArgs
 *                         {
 *                             Id = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectedItems/f8491e4f-817a-40dd-a90c-af773978c75b",
 *                             VirtualMachineId = "f8491e4f-817a-40dd-a90c-af773978c75b",
 *                         },
 *                     },
 *                     StartGroupActions = new[] {},
 *                 },
 *             },
 *             PrimaryFabricId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1",
 *             RecoveryFabricId = "Microsoft Azure",
 *         },
 *         RecoveryPlanName = "RPtest1",
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationRecoveryPlan(ctx, "replicationRecoveryPlan", &recoveryservices.ReplicationRecoveryPlanArgs{
 * 			Properties: recoveryservices.RecoveryPlanPropertiesResponse{
 * 				FailoverDeploymentModel: pulumi.String("ResourceManager"),
 * 				Groups: []recoveryservices.RecoveryPlanGroupArgs{
 * 					{
 * 						EndGroupActions: recoveryservices.RecoveryPlanActionArray{},
 * 						GroupType:       pulumi.String("Boot"),
 * 						ReplicationProtectedItems: recoveryservices.RecoveryPlanProtectedItemArray{
 * 							{
 * 								Id:               pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectedItems/f8491e4f-817a-40dd-a90c-af773978c75b"),
 * 								VirtualMachineId: pulumi.String("f8491e4f-817a-40dd-a90c-af773978c75b"),
 * 							},
 * 						},
 * 						StartGroupActions: recoveryservices.RecoveryPlanActionArray{},
 * 					},
 * 				},
 * 				PrimaryFabricId:  pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1"),
 * 				RecoveryFabricId: pulumi.String("Microsoft Azure"),
 * 			},
 * 			RecoveryPlanName:  pulumi.String("RPtest1"),
 * 			ResourceGroupName: pulumi.String("resourceGroupPS1"),
 * 			ResourceName:      pulumi.String("vault1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlan;
 * import com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationRecoveryPlan = new ReplicationRecoveryPlan("replicationRecoveryPlan", ReplicationRecoveryPlanArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("failoverDeploymentModel", "ResourceManager"),
 *                 Map.entry("groups", Map.ofEntries(
 *                     Map.entry("endGroupActions", ),
 *                     Map.entry("groupType", "Boot"),
 *                     Map.entry("replicationProtectedItems", Map.ofEntries(
 *                         Map.entry("id", "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectedItems/f8491e4f-817a-40dd-a90c-af773978c75b"),
 *                         Map.entry("virtualMachineId", "f8491e4f-817a-40dd-a90c-af773978c75b")
 *                     )),
 *                     Map.entry("startGroupActions", )
 *                 )),
 *                 Map.entry("primaryFabricId", "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1"),
 *                 Map.entry("recoveryFabricId", "Microsoft Azure")
 *             ))
 *             .recoveryPlanName("RPtest1")
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationRecoveryPlan RPtest1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}
 * ```
 * @property properties Recovery plan creation properties.
 * @property recoveryPlanName Recovery plan name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class ReplicationRecoveryPlanArgs(
    public val properties: Output<CreateRecoveryPlanInputPropertiesArgs>? = null,
    public val recoveryPlanName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlanArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlanArgs =
        com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlanArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recoveryPlanName(recoveryPlanName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationRecoveryPlanArgs].
 */
@PulumiTagMarker
public class ReplicationRecoveryPlanArgsBuilder internal constructor() {
    private var properties: Output<CreateRecoveryPlanInputPropertiesArgs>? = null

    private var recoveryPlanName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Recovery plan creation properties.
     */
    @JvmName("vdoqdcrnlflkanwj")
    public suspend fun properties(`value`: Output<CreateRecoveryPlanInputPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Recovery plan name.
     */
    @JvmName("pdbhuphqdoidgigk")
    public suspend fun recoveryPlanName(`value`: Output<String>) {
        this.recoveryPlanName = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("bnifjctlawrxklmw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("svyvpjuaircahpil")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Recovery plan creation properties.
     */
    @JvmName("ibqtkwnrxhtqxowu")
    public suspend fun properties(`value`: CreateRecoveryPlanInputPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Recovery plan creation properties.
     */
    @JvmName("wnhpiantclihpwcm")
    public suspend
    fun properties(argument: suspend CreateRecoveryPlanInputPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CreateRecoveryPlanInputPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Recovery plan name.
     */
    @JvmName("dwquddkgxtvurqee")
    public suspend fun recoveryPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPlanName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("jnlbfubfusfpfacy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("lgecwmhcgepuushc")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): ReplicationRecoveryPlanArgs = ReplicationRecoveryPlanArgs(
        properties = properties,
        recoveryPlanName = recoveryPlanName,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
