@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.RecoveryServicesProviderPropertiesResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.RecoveryServicesProviderPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationRecoveryServicesProvider].
 */
@PulumiTagMarker
public class ReplicationRecoveryServicesProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationRecoveryServicesProviderArgs =
        ReplicationRecoveryServicesProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ReplicationRecoveryServicesProviderArgsBuilder.() -> Unit) {
        val builder = ReplicationRecoveryServicesProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationRecoveryServicesProvider {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProvider(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationRecoveryServicesProvider(builtJavaResource)
    }
}

/**
 * Provider details.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01.
 * ## Example Usage
 * ### Adds a recovery services provider.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationRecoveryServicesProvider = new AzureNative.RecoveryServices.ReplicationRecoveryServicesProvider("replicationRecoveryServicesProvider", new()
 *     {
 *         FabricName = "vmwarefabric1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AddRecoveryServicesProviderInputPropertiesArgs
 *         {
 *             AuthenticationIdentityInput = new AzureNative.RecoveryServices.Inputs.IdentityProviderInputArgs
 *             {
 *                 AadAuthority = "https://login.microsoftonline.com",
 *                 ApplicationId = "f66fce08-c0c6-47a1-beeb-0ede5ea94f90",
 *                 Audience = "https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874",
 *                 ObjectId = "141360b8-5686-4240-a027-5e24e6affeba",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *             MachineName = "vmwareprovider1",
 *             ResourceAccessIdentityInput = new AzureNative.RecoveryServices.Inputs.IdentityProviderInputArgs
 *             {
 *                 AadAuthority = "https://login.microsoftonline.com",
 *                 ApplicationId = "f66fce08-c0c6-47a1-beeb-0ede5ea94f90",
 *                 Audience = "https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874",
 *                 ObjectId = "141360b8-5686-4240-a027-5e24e6affeba",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *         },
 *         ProviderName = "vmwareprovider1",
 *         ResourceGroupName = "resourcegroup1",
 *         ResourceName = "migrationvault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationRecoveryServicesProvider(ctx, "replicationRecoveryServicesProvider", &recoveryservices.ReplicationRecoveryServicesProviderArgs{
 * 			FabricName: pulumi.String("vmwarefabric1"),
 * 			Properties: recoveryservices.RecoveryServicesProviderPropertiesResponse{
 * 				AuthenticationIdentityInput: &recoveryservices.IdentityProviderInputArgs{
 * 					AadAuthority:  pulumi.String("https://login.microsoftonline.com"),
 * 					ApplicationId: pulumi.String("f66fce08-c0c6-47a1-beeb-0ede5ea94f90"),
 * 					Audience:      pulumi.String("https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874"),
 * 					ObjectId:      pulumi.String("141360b8-5686-4240-a027-5e24e6affeba"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 				MachineName: pulumi.String("vmwareprovider1"),
 * 				ResourceAccessIdentityInput: &recoveryservices.IdentityProviderInputArgs{
 * 					AadAuthority:  pulumi.String("https://login.microsoftonline.com"),
 * 					ApplicationId: pulumi.String("f66fce08-c0c6-47a1-beeb-0ede5ea94f90"),
 * 					Audience:      pulumi.String("https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874"),
 * 					ObjectId:      pulumi.String("141360b8-5686-4240-a027-5e24e6affeba"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 			},
 * 			ProviderName:      pulumi.String("vmwareprovider1"),
 * 			ResourceGroupName: pulumi.String("resourcegroup1"),
 * 			ResourceName:      pulumi.String("migrationvault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProvider;
 * import com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationRecoveryServicesProvider = new ReplicationRecoveryServicesProvider("replicationRecoveryServicesProvider", ReplicationRecoveryServicesProviderArgs.builder()
 *             .fabricName("vmwarefabric1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("authenticationIdentityInput", Map.ofEntries(
 *                     Map.entry("aadAuthority", "https://login.microsoftonline.com"),
 *                     Map.entry("applicationId", "f66fce08-c0c6-47a1-beeb-0ede5ea94f90"),
 *                     Map.entry("audience", "https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874"),
 *                     Map.entry("objectId", "141360b8-5686-4240-a027-5e24e6affeba"),
 *                     Map.entry("tenantId", "72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                 )),
 *                 Map.entry("machineName", "vmwareprovider1"),
 *                 Map.entry("resourceAccessIdentityInput", Map.ofEntries(
 *                     Map.entry("aadAuthority", "https://login.microsoftonline.com"),
 *                     Map.entry("applicationId", "f66fce08-c0c6-47a1-beeb-0ede5ea94f90"),
 *                     Map.entry("audience", "https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874"),
 *                     Map.entry("objectId", "141360b8-5686-4240-a027-5e24e6affeba"),
 *                     Map.entry("tenantId", "72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                 ))
 *             ))
 *             .providerName("vmwareprovider1")
 *             .resourceGroupName("resourcegroup1")
 *             .resourceName("migrationvault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationRecoveryServicesProvider vmwareprovider1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationRecoveryServicesProviders/{providerName}
 * ```
 */
public class ReplicationRecoveryServicesProvider internal constructor(
    override val javaResource:
    com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProvider,
) : KotlinCustomResource(javaResource, ReplicationRecoveryServicesProviderMapper) {
    /**
     * Resource Location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provider properties.
     */
    public val properties: Output<RecoveryServicesProviderPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationRecoveryServicesProviderMapper :
    ResourceMapper<ReplicationRecoveryServicesProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProvider::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationRecoveryServicesProvider =
        ReplicationRecoveryServicesProvider(
            javaResource as
                com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProvider,
        )
}

/**
 * @see [ReplicationRecoveryServicesProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationRecoveryServicesProvider].
 */
public suspend fun replicationRecoveryServicesProvider(
    name: String,
    block: suspend ReplicationRecoveryServicesProviderResourceBuilder.() -> Unit,
):
    ReplicationRecoveryServicesProvider {
    val builder = ReplicationRecoveryServicesProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationRecoveryServicesProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationRecoveryServicesProvider(name: String): ReplicationRecoveryServicesProvider {
    val builder = ReplicationRecoveryServicesProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
