@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMappingArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.StorageMappingInputPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.StorageMappingInputPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Storage mapping object.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01.
 * ## Example Usage
 * ### Create storage classification mapping.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationStorageClassificationMapping = new AzureNative.RecoveryServices.ReplicationStorageClassificationMapping("replicationStorageClassificationMapping", new()
 *     {
 *         FabricName = "2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0",
 *         Properties = new AzureNative.RecoveryServices.Inputs.StorageMappingInputPropertiesArgs
 *         {
 *             TargetStorageClassificationId = "/Subscriptions/9112a37f-0f3e-46ec-9c00-060c6edca071/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0/replicationStorageClassifications/8891569e-aaef-4a46-a4a0-78c14f2d7b09",
 *         },
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *         StorageClassificationMappingName = "testStorageMapping",
 *         StorageClassificationName = "8891569e-aaef-4a46-a4a0-78c14f2d7b09",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationStorageClassificationMapping(ctx, "replicationStorageClassificationMapping", &recoveryservices.ReplicationStorageClassificationMappingArgs{
 * 			FabricName: pulumi.String("2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0"),
 * 			Properties: &recoveryservices.StorageMappingInputPropertiesArgs{
 * 				TargetStorageClassificationId: pulumi.String("/Subscriptions/9112a37f-0f3e-46ec-9c00-060c6edca071/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0/replicationStorageClassifications/8891569e-aaef-4a46-a4a0-78c14f2d7b09"),
 * 			},
 * 			ResourceGroupName:                pulumi.String("resourceGroupPS1"),
 * 			ResourceName:                     pulumi.String("vault1"),
 * 			StorageClassificationMappingName: pulumi.String("testStorageMapping"),
 * 			StorageClassificationName:        pulumi.String("8891569e-aaef-4a46-a4a0-78c14f2d7b09"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMapping;
 * import com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationStorageClassificationMapping = new ReplicationStorageClassificationMapping("replicationStorageClassificationMapping", ReplicationStorageClassificationMappingArgs.builder()
 *             .fabricName("2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0")
 *             .properties(Map.of("targetStorageClassificationId", "/Subscriptions/9112a37f-0f3e-46ec-9c00-060c6edca071/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0/replicationStorageClassifications/8891569e-aaef-4a46-a4a0-78c14f2d7b09"))
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .storageClassificationMappingName("testStorageMapping")
 *             .storageClassificationName("8891569e-aaef-4a46-a4a0-78c14f2d7b09")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationStorageClassificationMapping testStorageMapping /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationStorageClassifications/{storageClassificationName}/replicationStorageClassificationMappings/{storageClassificationMappingName}
 * ```
 * @property fabricName Fabric name.
 * @property properties Storage mapping input properties.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 * @property storageClassificationMappingName Storage classification mapping name.
 * @property storageClassificationName Storage classification name.
 */
public data class ReplicationStorageClassificationMappingArgs(
    public val fabricName: Output<String>? = null,
    public val properties: Output<StorageMappingInputPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val storageClassificationMappingName: Output<String>? = null,
    public val storageClassificationName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMappingArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMappingArgs =
        com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMappingArgs.builder()
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .storageClassificationMappingName(storageClassificationMappingName?.applyValue({ args0 -> args0 }))
            .storageClassificationName(storageClassificationName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationStorageClassificationMappingArgs].
 */
@PulumiTagMarker
public class ReplicationStorageClassificationMappingArgsBuilder internal constructor() {
    private var fabricName: Output<String>? = null

    private var properties: Output<StorageMappingInputPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var storageClassificationMappingName: Output<String>? = null

    private var storageClassificationName: Output<String>? = null

    /**
     * @param value Fabric name.
     */
    @JvmName("xuynqioguiqwhkiv")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Storage mapping input properties.
     */
    @JvmName("rvcrikavmvfauanc")
    public suspend fun properties(`value`: Output<StorageMappingInputPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("brdlblbbkjctdudo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("ixaghaxtbtwahkdp")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Storage classification mapping name.
     */
    @JvmName("ssllxjcqtkctuqmh")
    public suspend fun storageClassificationMappingName(`value`: Output<String>) {
        this.storageClassificationMappingName = value
    }

    /**
     * @param value Storage classification name.
     */
    @JvmName("qysooaiuoaftolbe")
    public suspend fun storageClassificationName(`value`: Output<String>) {
        this.storageClassificationName = value
    }

    /**
     * @param value Fabric name.
     */
    @JvmName("lsjliugxcqwlanyt")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Storage mapping input properties.
     */
    @JvmName("kghgmugdjtyaipcy")
    public suspend fun properties(`value`: StorageMappingInputPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Storage mapping input properties.
     */
    @JvmName("xnvhnkkwetfkxrlm")
    public suspend
    fun properties(argument: suspend StorageMappingInputPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = StorageMappingInputPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("vfqllppkonhkpjae")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("uminwvkmmhpctmpv")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Storage classification mapping name.
     */
    @JvmName("jqykjivwnbveeabo")
    public suspend fun storageClassificationMappingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClassificationMappingName = mapped
    }

    /**
     * @param value Storage classification name.
     */
    @JvmName("jktvnkmhjrxpueqb")
    public suspend fun storageClassificationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClassificationName = mapped
    }

    internal fun build(): ReplicationStorageClassificationMappingArgs =
        ReplicationStorageClassificationMappingArgs(
            fabricName = fabricName,
            properties = properties,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            storageClassificationMappingName = storageClassificationMappingName,
            storageClassificationName = storageClassificationName,
        )
}
