@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ReplicationvCenterArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.AddVCenterRequestPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.AddVCenterRequestPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * vCenter definition.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2021-03-01, 2023-06-01.
 * ## Example Usage
 * ### Add vCenter.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationvCenter = new AzureNative.RecoveryServices.ReplicationvCenter("replicationvCenter", new()
 *     {
 *         FabricName = "MadhaviFabric",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AddVCenterRequestPropertiesArgs
 *         {
 *             FriendlyName = "esx-78",
 *             IpAddress = "inmtest78",
 *             Port = "443",
 *             ProcessServerId = "5A720CAB-39CB-F445-BD1662B0B33164B5",
 *             RunAsAccountId = "2",
 *         },
 *         ResourceGroupName = "MadhaviVRG",
 *         ResourceName = "MadhaviVault",
 *         VcenterName = "esx-78",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationvCenter(ctx, "replicationvCenter", &recoveryservices.ReplicationvCenterArgs{
 * 			FabricName: pulumi.String("MadhaviFabric"),
 * 			Properties: &recoveryservices.AddVCenterRequestPropertiesArgs{
 * 				FriendlyName:    pulumi.String("esx-78"),
 * 				IpAddress:       pulumi.String("inmtest78"),
 * 				Port:            pulumi.String("443"),
 * 				ProcessServerId: pulumi.String("5A720CAB-39CB-F445-BD1662B0B33164B5"),
 * 				RunAsAccountId:  pulumi.String("2"),
 * 			},
 * 			ResourceGroupName: pulumi.String("MadhaviVRG"),
 * 			ResourceName:      pulumi.String("MadhaviVault"),
 * 			VcenterName:       pulumi.String("esx-78"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationvCenter;
 * import com.pulumi.azurenative.recoveryservices.ReplicationvCenterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationvCenter = new ReplicationvCenter("replicationvCenter", ReplicationvCenterArgs.builder()
 *             .fabricName("MadhaviFabric")
 *             .properties(Map.ofEntries(
 *                 Map.entry("friendlyName", "esx-78"),
 *                 Map.entry("ipAddress", "inmtest78"),
 *                 Map.entry("port", "443"),
 *                 Map.entry("processServerId", "5A720CAB-39CB-F445-BD1662B0B33164B5"),
 *                 Map.entry("runAsAccountId", "2")
 *             ))
 *             .resourceGroupName("MadhaviVRG")
 *             .resourceName("MadhaviVault")
 *             .vcenterName("esx-78")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationvCenter esx-78 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationvCenters/{vcenterName}
 * ```
 * @property fabricName Fabric name.
 * @property properties The properties of an add vCenter request.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 * @property vcenterName vcenter name.
 */
public data class ReplicationvCenterArgs(
    public val fabricName: Output<String>? = null,
    public val properties: Output<AddVCenterRequestPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val vcenterName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ReplicationvCenterArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ReplicationvCenterArgs =
        com.pulumi.azurenative.recoveryservices.ReplicationvCenterArgs.builder()
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .vcenterName(vcenterName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationvCenterArgs].
 */
@PulumiTagMarker
public class ReplicationvCenterArgsBuilder internal constructor() {
    private var fabricName: Output<String>? = null

    private var properties: Output<AddVCenterRequestPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var vcenterName: Output<String>? = null

    /**
     * @param value Fabric name.
     */
    @JvmName("vtipgmewpuhoeclj")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value The properties of an add vCenter request.
     */
    @JvmName("nogfonxjkpfgiipu")
    public suspend fun properties(`value`: Output<AddVCenterRequestPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("yscneobvhfsvlpdn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("lkysjydctcyyduue")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value vcenter name.
     */
    @JvmName("gbmspunoenohwlro")
    public suspend fun vcenterName(`value`: Output<String>) {
        this.vcenterName = value
    }

    /**
     * @param value Fabric name.
     */
    @JvmName("pgqbrcoaajtdluhd")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value The properties of an add vCenter request.
     */
    @JvmName("bsnthhdralxwhsrg")
    public suspend fun properties(`value`: AddVCenterRequestPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of an add vCenter request.
     */
    @JvmName("mqaudkjckykvihjo")
    public suspend
    fun properties(argument: suspend AddVCenterRequestPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AddVCenterRequestPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("xqqsihvsgrunyupt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("kpalpecmeqwpgeld")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value vcenter name.
     */
    @JvmName("opleujwnvqslclpy")
    public suspend fun vcenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vcenterName = mapped
    }

    internal fun build(): ReplicationvCenterArgs = ReplicationvCenterArgs(
        fabricName = fabricName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        vcenterName = vcenterName,
    )
}
