@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.ResourceGuardProxyBaseResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.ResourceGuardProxyBaseResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ResourceGuardProxy].
 */
@PulumiTagMarker
public class ResourceGuardProxyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceGuardProxyArgs = ResourceGuardProxyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceGuardProxyArgsBuilder.() -> Unit) {
        val builder = ResourceGuardProxyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResourceGuardProxy {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ResourceGuardProxy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResourceGuardProxy(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2023-06-01.
 * ## Example Usage
 * ### Create ResourceGuardProxy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceGuardProxy = new AzureNative.RecoveryServices.ResourceGuardProxy("resourceGuardProxy", new()
 *     {
 *         Properties = new AzureNative.RecoveryServices.Inputs.ResourceGuardProxyBaseArgs
 *         {
 *             ResourceGuardResourceId = "/subscriptions/c999d45b-944f-418c-a0d8-c3fcfd1802c8/resourceGroups/vaultguardRGNew/providers/Microsoft.DataProtection/resourceGuards/VaultGuardTestNew",
 *         },
 *         ResourceGroupName = "SampleResourceGroup",
 *         ResourceGuardProxyName = "swaggerExample",
 *         VaultName = "sampleVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewResourceGuardProxy(ctx, "resourceGuardProxy", &recoveryservices.ResourceGuardProxyArgs{
 * 			Properties: &recoveryservices.ResourceGuardProxyBaseArgs{
 * 				ResourceGuardResourceId: pulumi.String("/subscriptions/c999d45b-944f-418c-a0d8-c3fcfd1802c8/resourceGroups/vaultguardRGNew/providers/Microsoft.DataProtection/resourceGuards/VaultGuardTestNew"),
 * 			},
 * 			ResourceGroupName:      pulumi.String("SampleResourceGroup"),
 * 			ResourceGuardProxyName: pulumi.String("swaggerExample"),
 * 			VaultName:              pulumi.String("sampleVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ResourceGuardProxy;
 * import com.pulumi.azurenative.recoveryservices.ResourceGuardProxyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceGuardProxy = new ResourceGuardProxy("resourceGuardProxy", ResourceGuardProxyArgs.builder()
 *             .properties(Map.of("resourceGuardResourceId", "/subscriptions/c999d45b-944f-418c-a0d8-c3fcfd1802c8/resourceGroups/vaultguardRGNew/providers/Microsoft.DataProtection/resourceGuards/VaultGuardTestNew"))
 *             .resourceGroupName("SampleResourceGroup")
 *             .resourceGuardProxyName("swaggerExample")
 *             .vaultName("sampleVault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ResourceGuardProxy swaggerExample /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}
 * ```
 */
public class ResourceGuardProxy internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ResourceGuardProxy,
) : KotlinCustomResource(javaResource, ResourceGuardProxyMapper) {
    /**
     * Optional ETag.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name associated with the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ResourceGuardProxyBaseResource properties
     */
    public val properties: Output<ResourceGuardProxyBaseResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ResourceGuardProxyMapper : ResourceMapper<ResourceGuardProxy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ResourceGuardProxy::class == javaResource::class

    override fun map(javaResource: Resource): ResourceGuardProxy = ResourceGuardProxy(
        javaResource as
            com.pulumi.azurenative.recoveryservices.ResourceGuardProxy,
    )
}

/**
 * @see [ResourceGuardProxy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceGuardProxy].
 */
public suspend fun resourceGuardProxy(
    name: String,
    block: suspend ResourceGuardProxyResourceBuilder.() -> Unit,
): ResourceGuardProxy {
    val builder = ResourceGuardProxyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceGuardProxy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceGuardProxy(name: String): ResourceGuardProxy {
    val builder = ResourceGuardProxyResourceBuilder()
    builder.name(name)
    return builder.build()
}
