@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.A2ACrossClusterMigrationPolicyCreationInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A2A Cross-Cluster Migration Policy creation input.
 * @property instanceType The class type.
 * Expected value is 'A2ACrossClusterMigration'.
 */
public data class A2ACrossClusterMigrationPolicyCreationInputArgs(
    public val instanceType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.A2ACrossClusterMigrationPolicyCreationInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.A2ACrossClusterMigrationPolicyCreationInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.A2ACrossClusterMigrationPolicyCreationInputArgs.builder()
            .instanceType(instanceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [A2ACrossClusterMigrationPolicyCreationInputArgs].
 */
@PulumiTagMarker
public class A2ACrossClusterMigrationPolicyCreationInputArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    /**
     * @param value The class type.
     * Expected value is 'A2ACrossClusterMigration'.
     */
    @JvmName("gjtukhiylknmwbll")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The class type.
     * Expected value is 'A2ACrossClusterMigration'.
     */
    @JvmName("nlgtwpwtxqyjxiis")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    internal fun build(): A2ACrossClusterMigrationPolicyCreationInputArgs =
        A2ACrossClusterMigrationPolicyCreationInputArgs(
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        )
}
