@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AADProperties.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property audience
 * @property authority
 * @property servicePrincipalClientId
 * @property servicePrincipalObjectId
 * @property tenantId
 */
public data class AADProperties(
    public val audience: String? = null,
    public val authority: String? = null,
    public val servicePrincipalClientId: String? = null,
    public val servicePrincipalObjectId: String? = null,
    public val tenantId: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AADProperties> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.AADProperties =
        com.pulumi.azurenative.recoveryservices.inputs.AADProperties.builder()
            .audience(audience?.let({ args0 -> args0 }))
            .authority(authority?.let({ args0 -> args0 }))
            .servicePrincipalClientId(servicePrincipalClientId?.let({ args0 -> args0 }))
            .servicePrincipalObjectId(servicePrincipalObjectId?.let({ args0 -> args0 }))
            .tenantId(tenantId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [AADProperties].
 */
@PulumiTagMarker
public class AADPropertiesBuilder internal constructor() {
    private var audience: String? = null

    private var authority: String? = null

    private var servicePrincipalClientId: String? = null

    private var servicePrincipalObjectId: String? = null

    private var tenantId: String? = null

    /**
     * @param value
     */
    @JvmName("lgauakldsdeckkfh")
    public suspend fun audience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.audience = mapped
    }

    /**
     * @param value
     */
    @JvmName("ywbqlvyskmfmpdtw")
    public suspend fun authority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.authority = mapped
    }

    /**
     * @param value
     */
    @JvmName("cvwjktehiofwjfcn")
    public suspend fun servicePrincipalClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.servicePrincipalClientId = mapped
    }

    /**
     * @param value
     */
    @JvmName("lggftakwvoryahon")
    public suspend fun servicePrincipalObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.servicePrincipalObjectId = mapped
    }

    /**
     * @param value
     */
    @JvmName("luxcfmcsqhemamjp")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tenantId = mapped
    }

    internal fun build(): AADProperties = AADProperties(
        audience = audience,
        authority = authority,
        servicePrincipalClientId = servicePrincipalClientId,
        servicePrincipalObjectId = servicePrincipalObjectId,
        tenantId = tenantId,
    )
}
