@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureFabricCreationInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Fabric provider specific settings.
 * @property instanceType Gets the class type.
 * Expected value is 'Azure'.
 * @property location The Location.
 */
public data class AzureFabricCreationInputArgs(
    public val instanceType: Output<String>,
    public val location: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureFabricCreationInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.AzureFabricCreationInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureFabricCreationInputArgs.builder()
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFabricCreationInputArgs].
 */
@PulumiTagMarker
public class AzureFabricCreationInputArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var location: Output<String>? = null

    /**
     * @param value Gets the class type.
     * Expected value is 'Azure'.
     */
    @JvmName("rhfmxdhvpjrtbgbh")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The Location.
     */
    @JvmName("ofdmbkflxaooihst")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Gets the class type.
     * Expected value is 'Azure'.
     */
    @JvmName("iubqviaedjcuicqx")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The Location.
     */
    @JvmName("vkthagejdgofmbfd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    internal fun build(): AzureFabricCreationInputArgs = AzureFabricCreationInputArgs(
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        location = location,
    )
}
