@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSClassicComputeVMContainerArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.BackupManagementType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IaaS VM workload-specific backup item representing a classic virtual machine.
 * @property backupManagementType Type of backup management for the container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 * @property resourceGroup Resource group name of Recovery Services Vault.
 * @property virtualMachineId Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
 * @property virtualMachineVersion Specifies whether the container represents a Classic or an Azure Resource Manager VM.
 */
public data class AzureIaaSClassicComputeVMContainerArgs(
    public val backupManagementType: Output<Either<String, BackupManagementType>>? = null,
    public val containerType: Output<String>,
    public val friendlyName: Output<String>? = null,
    public val healthStatus: Output<String>? = null,
    public val protectableObjectType: Output<String>? = null,
    public val registrationStatus: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val virtualMachineId: Output<String>? = null,
    public val virtualMachineVersion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSClassicComputeVMContainerArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSClassicComputeVMContainerArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSClassicComputeVMContainerArgs.builder()
            .backupManagementType(
                backupManagementType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .containerType(containerType.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .healthStatus(healthStatus?.applyValue({ args0 -> args0 }))
            .protectableObjectType(protectableObjectType?.applyValue({ args0 -> args0 }))
            .registrationStatus(registrationStatus?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .virtualMachineId(virtualMachineId?.applyValue({ args0 -> args0 }))
            .virtualMachineVersion(virtualMachineVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureIaaSClassicComputeVMContainerArgs].
 */
@PulumiTagMarker
public class AzureIaaSClassicComputeVMContainerArgsBuilder internal constructor() {
    private var backupManagementType: Output<Either<String, BackupManagementType>>? = null

    private var containerType: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var healthStatus: Output<String>? = null

    private var protectableObjectType: Output<String>? = null

    private var registrationStatus: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var virtualMachineId: Output<String>? = null

    private var virtualMachineVersion: Output<String>? = null

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("ikcyijgrgcerrphw")
    public suspend fun backupManagementType(`value`: Output<Either<String, BackupManagementType>>) {
        this.backupManagementType = value
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
     */
    @JvmName("qaxtpquhfsogvybb")
    public suspend fun containerType(`value`: Output<String>) {
        this.containerType = value
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("phvqlhcinkheqxpf")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("qdfaisdfrrctfage")
    public suspend fun healthStatus(`value`: Output<String>) {
        this.healthStatus = value
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("dwywtslgcxscbtfg")
    public suspend fun protectableObjectType(`value`: Output<String>) {
        this.protectableObjectType = value
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("dghomwlydbufanbc")
    public suspend fun registrationStatus(`value`: Output<String>) {
        this.registrationStatus = value
    }

    /**
     * @param value Resource group name of Recovery Services Vault.
     */
    @JvmName("xcfqjqupytwvyemc")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
     */
    @JvmName("dsqohsaxkrwardjr")
    public suspend fun virtualMachineId(`value`: Output<String>) {
        this.virtualMachineId = value
    }

    /**
     * @param value Specifies whether the container represents a Classic or an Azure Resource Manager VM.
     */
    @JvmName("nwmcepkagtmgwxwt")
    public suspend fun virtualMachineVersion(`value`: Output<String>) {
        this.virtualMachineVersion = value
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("pnlxkvcqfjhyuspl")
    public suspend fun backupManagementType(`value`: Either<String, BackupManagementType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("lpstvvbmcyfvbesr")
    public fun backupManagementType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("tbljhisolxoqtlkt")
    public fun backupManagementType(`value`: BackupManagementType) {
        val toBeMapped = Either.ofRight<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
     */
    @JvmName("dqqehvwcklvaelka")
    public suspend fun containerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerType = mapped
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("ejigoryolardvror")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("soyoopxwwcjrisjl")
    public suspend fun healthStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthStatus = mapped
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("mgyuvcchrwcgvhda")
    public suspend fun protectableObjectType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectableObjectType = mapped
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("ebqarukgnccvnpse")
    public suspend fun registrationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationStatus = mapped
    }

    /**
     * @param value Resource group name of Recovery Services Vault.
     */
    @JvmName("oyvenafcsvoftoox")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
     */
    @JvmName("jdbuurwluxpkhiil")
    public suspend fun virtualMachineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineId = mapped
    }

    /**
     * @param value Specifies whether the container represents a Classic or an Azure Resource Manager VM.
     */
    @JvmName("gtjwpfotwiylyqqf")
    public suspend fun virtualMachineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineVersion = mapped
    }

    internal fun build(): AzureIaaSClassicComputeVMContainerArgs =
        AzureIaaSClassicComputeVMContainerArgs(
            backupManagementType = backupManagementType,
            containerType = containerType ?: throw PulumiNullFieldException("containerType"),
            friendlyName = friendlyName,
            healthStatus = healthStatus,
            protectableObjectType = protectableObjectType,
            registrationStatus = registrationStatus,
            resourceGroup = resourceGroup,
            virtualMachineId = virtualMachineId,
            virtualMachineVersion = virtualMachineVersion,
        )
}
