@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureResourceProtectionIntentArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.BackupManagementType
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ProtectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IaaS VM specific backup protection intent item.
 * @property backupManagementType Type of backup management for the backed up item.
 * @property friendlyName Friendly name of the VM represented by this backup item.
 * @property itemId ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
 * @property policyId ID of the backup policy with which this item is backed up.
 * @property protectionIntentItemType backup protectionIntent type.
 * Expected value is 'AzureResourceItem'.
 * @property protectionState Backup state of this backup item.
 * @property sourceResourceId ARM ID of the resource to be backed up.
 */
public data class AzureResourceProtectionIntentArgs(
    public val backupManagementType: Output<Either<String, BackupManagementType>>? = null,
    public val friendlyName: Output<String>? = null,
    public val itemId: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val protectionIntentItemType: Output<String>,
    public val protectionState: Output<Either<String, ProtectionStatus>>? = null,
    public val sourceResourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureResourceProtectionIntentArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureResourceProtectionIntentArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureResourceProtectionIntentArgs.builder()
            .backupManagementType(
                backupManagementType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .itemId(itemId?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .protectionIntentItemType(protectionIntentItemType.applyValue({ args0 -> args0 }))
            .protectionState(
                protectionState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureResourceProtectionIntentArgs].
 */
@PulumiTagMarker
public class AzureResourceProtectionIntentArgsBuilder internal constructor() {
    private var backupManagementType: Output<Either<String, BackupManagementType>>? = null

    private var friendlyName: Output<String>? = null

    private var itemId: Output<String>? = null

    private var policyId: Output<String>? = null

    private var protectionIntentItemType: Output<String>? = null

    private var protectionState: Output<Either<String, ProtectionStatus>>? = null

    private var sourceResourceId: Output<String>? = null

    /**
     * @param value Type of backup management for the backed up item.
     */
    @JvmName("obfftuqfhmiqfxwv")
    public suspend fun backupManagementType(`value`: Output<Either<String, BackupManagementType>>) {
        this.backupManagementType = value
    }

    /**
     * @param value Friendly name of the VM represented by this backup item.
     */
    @JvmName("trjqxvfelvqkcqqu")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
     */
    @JvmName("njwnlscpmwakvkjk")
    public suspend fun itemId(`value`: Output<String>) {
        this.itemId = value
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("vwonvcpdpnkeklkl")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value backup protectionIntent type.
     * Expected value is 'AzureResourceItem'.
     */
    @JvmName("qrcslcrbhmlgqyie")
    public suspend fun protectionIntentItemType(`value`: Output<String>) {
        this.protectionIntentItemType = value
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("ypcdmotdbjqwugxw")
    public suspend fun protectionState(`value`: Output<Either<String, ProtectionStatus>>) {
        this.protectionState = value
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("mwtheqilayoxeluh")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Type of backup management for the backed up item.
     */
    @JvmName("tstvxwmoabqocnev")
    public suspend fun backupManagementType(`value`: Either<String, BackupManagementType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the backed up item.
     */
    @JvmName("smsnabbbgvniwdpy")
    public fun backupManagementType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the backed up item.
     */
    @JvmName("fvgrhehtnxnneste")
    public fun backupManagementType(`value`: BackupManagementType) {
        val toBeMapped = Either.ofRight<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Friendly name of the VM represented by this backup item.
     */
    @JvmName("gqpkaibhxncftpah")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
     */
    @JvmName("idapfcuceawoysyp")
    public suspend fun itemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.itemId = mapped
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("cgbnkqxhyikbalwb")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value backup protectionIntent type.
     * Expected value is 'AzureResourceItem'.
     */
    @JvmName("pjdaysmuuiattuok")
    public suspend fun protectionIntentItemType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionIntentItemType = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("syouygbahpvwvqot")
    public suspend fun protectionState(`value`: Either<String, ProtectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("kdsciktnfmgmsnnw")
    public fun protectionState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("essgisbfvmuxhgsv")
    public fun protectionState(`value`: ProtectionStatus) {
        val toBeMapped = Either.ofRight<String, ProtectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("himjjuafnqygspag")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    internal fun build(): AzureResourceProtectionIntentArgs = AzureResourceProtectionIntentArgs(
        backupManagementType = backupManagementType,
        friendlyName = friendlyName,
        itemId = itemId,
        policyId = policyId,
        protectionIntentItemType = protectionIntentItemType ?: throw
            PulumiNullFieldException("protectionIntentItemType"),
        protectionState = protectionState,
        sourceResourceId = sourceResourceId,
    )
}
