@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureToAzureCreateNetworkMappingInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Create network mappings input properties/behavior specific to Azure to Azure Network mapping.
 * @property instanceType The instance type.
 * Expected value is 'AzureToAzure'.
 * @property primaryNetworkId The primary azure vnet Id.
 */
public data class AzureToAzureCreateNetworkMappingInputArgs(
    public val instanceType: Output<String>,
    public val primaryNetworkId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureToAzureCreateNetworkMappingInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureToAzureCreateNetworkMappingInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureToAzureCreateNetworkMappingInputArgs.builder()
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .primaryNetworkId(primaryNetworkId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureToAzureCreateNetworkMappingInputArgs].
 */
@PulumiTagMarker
public class AzureToAzureCreateNetworkMappingInputArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var primaryNetworkId: Output<String>? = null

    /**
     * @param value The instance type.
     * Expected value is 'AzureToAzure'.
     */
    @JvmName("fldoimftnqhyvmjr")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The primary azure vnet Id.
     */
    @JvmName("kqfwpwppamlrcjja")
    public suspend fun primaryNetworkId(`value`: Output<String>) {
        this.primaryNetworkId = value
    }

    /**
     * @param value The instance type.
     * Expected value is 'AzureToAzure'.
     */
    @JvmName("hrhnowoibjhjmvwr")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The primary azure vnet Id.
     */
    @JvmName("esgixntvjdxmyubi")
    public suspend fun primaryNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryNetworkId = mapped
    }

    internal fun build(): AzureToAzureCreateNetworkMappingInputArgs =
        AzureToAzureCreateNetworkMappingInputArgs(
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            primaryNetworkId = primaryNetworkId ?: throw PulumiNullFieldException("primaryNetworkId"),
        )
}
