@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadSAPAseDatabaseProtectedItemArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.CreateMode
import com.pulumi.azurenative.recoveryservices.kotlin.enums.LastBackupStatus
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ProtectedItemHealthStatus
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ProtectionState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure VM workload-specific protected item representing SAP ASE Database.
 * @property backupSetName Name of the backup set the backup item belongs to
 * @property containerName Unique name of container
 * @property createMode Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
 * @property deferredDeleteTimeInUTC Time for deferred deletion in UTC
 * @property deferredDeleteTimeRemaining Time remaining before the DS marked for deferred delete is permanently deleted
 * @property extendedInfo Additional information for this backup item.
 * @property isArchiveEnabled Flag to identify whether datasource is protected in archive
 * @property isDeferredDeleteScheduleUpcoming Flag to identify whether the deferred deleted DS is to be purged soon
 * @property isRehydrate Flag to identify that deferred deleted DS is to be moved into Pause state
 * @property isScheduledForDeferredDelete Flag to identify whether the DS is scheduled for deferred delete
 * @property kpisHealths Health details of different KPIs
 * @property lastBackupStatus Last backup operation status. Possible values: Healthy, Unhealthy.
 * @property lastBackupTime Timestamp of the last backup operation on this backup item.
 * @property lastRecoveryPoint Timestamp when the last (latest) backup copy was created for this backup item.
 * @property nodesList List of the nodes in case of distributed container.
 * @property parentName Parent name of the DB such as Instance or Availability Group.
 * @property parentType Parent type of protected item, example: for a DB, standalone server or distributed
 * @property policyId ID of the backup policy with which this item is backed up.
 * @property policyName Name of the policy used for protection
 * @property protectedItemDataSourceId Data ID of the protected item.
 * @property protectedItemHealthStatus Health status of the backup item, evaluated based on last heartbeat received
 * @property protectedItemType backup item type.
 * Expected value is 'AzureVmWorkloadSAPAseDatabase'.
 * @property protectionState Backup state of this backup item.
 * @property resourceGuardOperationRequests ResourceGuardOperationRequests on which LAC check will be performed
 * @property serverName Host/Cluster Name for instance or AG
 * @property softDeleteRetentionPeriodInDays Soft delete retention period in days
 * @property sourceResourceId ARM ID of the resource to be backed up.
 */
public data class AzureVmWorkloadSAPAseDatabaseProtectedItemArgs(
    public val backupSetName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val createMode: Output<Either<String, CreateMode>>? = null,
    public val deferredDeleteTimeInUTC: Output<String>? = null,
    public val deferredDeleteTimeRemaining: Output<String>? = null,
    public val extendedInfo: Output<AzureVmWorkloadProtectedItemExtendedInfoArgs>? = null,
    public val isArchiveEnabled: Output<Boolean>? = null,
    public val isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null,
    public val isRehydrate: Output<Boolean>? = null,
    public val isScheduledForDeferredDelete: Output<Boolean>? = null,
    public val kpisHealths: Output<Map<String, KPIResourceHealthDetailsArgs>>? = null,
    public val lastBackupStatus: Output<Either<String, LastBackupStatus>>? = null,
    public val lastBackupTime: Output<String>? = null,
    public val lastRecoveryPoint: Output<String>? = null,
    public val nodesList: Output<List<DistributedNodesInfoArgs>>? = null,
    public val parentName: Output<String>? = null,
    public val parentType: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val protectedItemDataSourceId: Output<String>? = null,
    public val protectedItemHealthStatus: Output<Either<String, ProtectedItemHealthStatus>>? = null,
    public val protectedItemType: Output<String>,
    public val protectionState: Output<Either<String, ProtectionState>>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val serverName: Output<String>? = null,
    public val softDeleteRetentionPeriodInDays: Output<Int>? = null,
    public val sourceResourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadSAPAseDatabaseProtectedItemArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadSAPAseDatabaseProtectedItemArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadSAPAseDatabaseProtectedItemArgs.builder()
            .backupSetName(backupSetName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deferredDeleteTimeInUTC(deferredDeleteTimeInUTC?.applyValue({ args0 -> args0 }))
            .deferredDeleteTimeRemaining(deferredDeleteTimeRemaining?.applyValue({ args0 -> args0 }))
            .extendedInfo(extendedInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isArchiveEnabled(isArchiveEnabled?.applyValue({ args0 -> args0 }))
            .isDeferredDeleteScheduleUpcoming(isDeferredDeleteScheduleUpcoming?.applyValue({ args0 -> args0 }))
            .isRehydrate(isRehydrate?.applyValue({ args0 -> args0 }))
            .isScheduledForDeferredDelete(isScheduledForDeferredDelete?.applyValue({ args0 -> args0 }))
            .kpisHealths(
                kpisHealths?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .lastBackupStatus(
                lastBackupStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .lastBackupTime(lastBackupTime?.applyValue({ args0 -> args0 }))
            .lastRecoveryPoint(lastRecoveryPoint?.applyValue({ args0 -> args0 }))
            .nodesList(
                nodesList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .parentName(parentName?.applyValue({ args0 -> args0 }))
            .parentType(parentType?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .protectedItemDataSourceId(protectedItemDataSourceId?.applyValue({ args0 -> args0 }))
            .protectedItemHealthStatus(
                protectedItemHealthStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .protectedItemType(protectedItemType.applyValue({ args0 -> args0 }))
            .protectionState(
                protectionState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .softDeleteRetentionPeriodInDays(softDeleteRetentionPeriodInDays?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureVmWorkloadSAPAseDatabaseProtectedItemArgs].
 */
@PulumiTagMarker
public class AzureVmWorkloadSAPAseDatabaseProtectedItemArgsBuilder internal constructor() {
    private var backupSetName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var createMode: Output<Either<String, CreateMode>>? = null

    private var deferredDeleteTimeInUTC: Output<String>? = null

    private var deferredDeleteTimeRemaining: Output<String>? = null

    private var extendedInfo: Output<AzureVmWorkloadProtectedItemExtendedInfoArgs>? = null

    private var isArchiveEnabled: Output<Boolean>? = null

    private var isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null

    private var isRehydrate: Output<Boolean>? = null

    private var isScheduledForDeferredDelete: Output<Boolean>? = null

    private var kpisHealths: Output<Map<String, KPIResourceHealthDetailsArgs>>? = null

    private var lastBackupStatus: Output<Either<String, LastBackupStatus>>? = null

    private var lastBackupTime: Output<String>? = null

    private var lastRecoveryPoint: Output<String>? = null

    private var nodesList: Output<List<DistributedNodesInfoArgs>>? = null

    private var parentName: Output<String>? = null

    private var parentType: Output<String>? = null

    private var policyId: Output<String>? = null

    private var policyName: Output<String>? = null

    private var protectedItemDataSourceId: Output<String>? = null

    private var protectedItemHealthStatus: Output<Either<String, ProtectedItemHealthStatus>>? = null

    private var protectedItemType: Output<String>? = null

    private var protectionState: Output<Either<String, ProtectionState>>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var serverName: Output<String>? = null

    private var softDeleteRetentionPeriodInDays: Output<Int>? = null

    private var sourceResourceId: Output<String>? = null

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("wopfqpseedlibdac")
    public suspend fun backupSetName(`value`: Output<String>) {
        this.backupSetName = value
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("xdygduwrqpouwifk")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("xdrhplydxcvgujnw")
    public suspend fun createMode(`value`: Output<Either<String, CreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("vuhbscgrffhhunmx")
    public suspend fun deferredDeleteTimeInUTC(`value`: Output<String>) {
        this.deferredDeleteTimeInUTC = value
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("dypnkjvimuvhblbu")
    public suspend fun deferredDeleteTimeRemaining(`value`: Output<String>) {
        this.deferredDeleteTimeRemaining = value
    }

    /**
     * @param value Additional information for this backup item.
     */
    @JvmName("vgdqwulgykwjrqdc")
    public suspend fun extendedInfo(`value`: Output<AzureVmWorkloadProtectedItemExtendedInfoArgs>) {
        this.extendedInfo = value
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("gfqwtvxgovcjlhom")
    public suspend fun isArchiveEnabled(`value`: Output<Boolean>) {
        this.isArchiveEnabled = value
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("mgyqyakqheiukesh")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Output<Boolean>) {
        this.isDeferredDeleteScheduleUpcoming = value
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("tegmmomuxvmrwudk")
    public suspend fun isRehydrate(`value`: Output<Boolean>) {
        this.isRehydrate = value
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("ijswqrciiselxpcn")
    public suspend fun isScheduledForDeferredDelete(`value`: Output<Boolean>) {
        this.isScheduledForDeferredDelete = value
    }

    /**
     * @param value Health details of different KPIs
     */
    @JvmName("sedobxnbcdmyuhrk")
    public suspend fun kpisHealths(`value`: Output<Map<String, KPIResourceHealthDetailsArgs>>) {
        this.kpisHealths = value
    }

    /**
     * @param value Last backup operation status. Possible values: Healthy, Unhealthy.
     */
    @JvmName("ybwxtljumdxuctdk")
    public suspend fun lastBackupStatus(`value`: Output<Either<String, LastBackupStatus>>) {
        this.lastBackupStatus = value
    }

    /**
     * @param value Timestamp of the last backup operation on this backup item.
     */
    @JvmName("jefsbywufxgperbj")
    public suspend fun lastBackupTime(`value`: Output<String>) {
        this.lastBackupTime = value
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("qecgiwxkbnvkyquf")
    public suspend fun lastRecoveryPoint(`value`: Output<String>) {
        this.lastRecoveryPoint = value
    }

    /**
     * @param value List of the nodes in case of distributed container.
     */
    @JvmName("jiulsxichwaucrst")
    public suspend fun nodesList(`value`: Output<List<DistributedNodesInfoArgs>>) {
        this.nodesList = value
    }

    @JvmName("rnjnovmkquouxowl")
    public suspend fun nodesList(vararg values: Output<DistributedNodesInfoArgs>) {
        this.nodesList = Output.all(values.asList())
    }

    /**
     * @param values List of the nodes in case of distributed container.
     */
    @JvmName("yrhphoyuucglujxv")
    public suspend fun nodesList(values: List<Output<DistributedNodesInfoArgs>>) {
        this.nodesList = Output.all(values)
    }

    /**
     * @param value Parent name of the DB such as Instance or Availability Group.
     */
    @JvmName("hdebklnqyykrnnvb")
    public suspend fun parentName(`value`: Output<String>) {
        this.parentName = value
    }

    /**
     * @param value Parent type of protected item, example: for a DB, standalone server or distributed
     */
    @JvmName("jfewdtusejqqgbee")
    public suspend fun parentType(`value`: Output<String>) {
        this.parentType = value
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("fptyxbpygawojgfq")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("ttgliswdpqgeobxx")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Data ID of the protected item.
     */
    @JvmName("wgipvxbhghwfyaoa")
    public suspend fun protectedItemDataSourceId(`value`: Output<String>) {
        this.protectedItemDataSourceId = value
    }

    /**
     * @param value Health status of the backup item, evaluated based on last heartbeat received
     */
    @JvmName("qbgssiepwjkjfetd")
    public suspend
    fun protectedItemHealthStatus(`value`: Output<Either<String, ProtectedItemHealthStatus>>) {
        this.protectedItemHealthStatus = value
    }

    /**
     * @param value backup item type.
     * Expected value is 'AzureVmWorkloadSAPAseDatabase'.
     */
    @JvmName("brfgfpvbdoigqikw")
    public suspend fun protectedItemType(`value`: Output<String>) {
        this.protectedItemType = value
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("ipaudqqhyfdtqxiy")
    public suspend fun protectionState(`value`: Output<Either<String, ProtectionState>>) {
        this.protectionState = value
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("bbycmnvsvvmbxbqh")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("vgyljaflpvqjsnyn")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("hiydjgfojvyarped")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value Host/Cluster Name for instance or AG
     */
    @JvmName("hyodggwpgdlawisn")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("xofkvvonmhulgnmg")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Output<Int>) {
        this.softDeleteRetentionPeriodInDays = value
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("eubbopqxctgbkepv")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("wykxnlikmvouragn")
    public suspend fun backupSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupSetName = mapped
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("llpqdckiegqictgh")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("bvjibaqqwqiwtolq")
    public suspend fun createMode(`value`: Either<String, CreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("ppgqvougecoxgwjp")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("ebaxxftxpqpncxuj")
    public fun createMode(`value`: CreateMode) {
        val toBeMapped = Either.ofRight<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("nrcsuyrejeegvsxc")
    public suspend fun deferredDeleteTimeInUTC(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeInUTC = mapped
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("wcuqommlwpnklfbd")
    public suspend fun deferredDeleteTimeRemaining(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeRemaining = mapped
    }

    /**
     * @param value Additional information for this backup item.
     */
    @JvmName("flvenmbrxjnactlm")
    public suspend fun extendedInfo(`value`: AzureVmWorkloadProtectedItemExtendedInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedInfo = mapped
    }

    /**
     * @param argument Additional information for this backup item.
     */
    @JvmName("bpuqsmuuwueufhuo")
    public suspend
    fun extendedInfo(argument: suspend AzureVmWorkloadProtectedItemExtendedInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AzureVmWorkloadProtectedItemExtendedInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extendedInfo = mapped
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("tynyosnqphyictcj")
    public suspend fun isArchiveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchiveEnabled = mapped
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("rmpklpymppqvhvpe")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDeferredDeleteScheduleUpcoming = mapped
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("uykjeupxvykgidhv")
    public suspend fun isRehydrate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRehydrate = mapped
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("wxgdvvqdntjpjedg")
    public suspend fun isScheduledForDeferredDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isScheduledForDeferredDelete = mapped
    }

    /**
     * @param value Health details of different KPIs
     */
    @JvmName("fkjlebspjeqjebbo")
    public suspend fun kpisHealths(`value`: Map<String, KPIResourceHealthDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kpisHealths = mapped
    }

    /**
     * @param argument Health details of different KPIs
     */
    @JvmName("fmdffrlwlenxwusu")
    public suspend fun kpisHealths(
        vararg
        argument: Pair<String, suspend KPIResourceHealthDetailsArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                KPIResourceHealthDetailsArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.kpisHealths = mapped
    }

    /**
     * @param values Health details of different KPIs
     */
    @JvmName("njvsajhyhmudutxk")
    public fun kpisHealths(vararg values: Pair<String, KPIResourceHealthDetailsArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kpisHealths = mapped
    }

    /**
     * @param value Last backup operation status. Possible values: Healthy, Unhealthy.
     */
    @JvmName("lvddybgkxegrgkub")
    public suspend fun lastBackupStatus(`value`: Either<String, LastBackupStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastBackupStatus = mapped
    }

    /**
     * @param value Last backup operation status. Possible values: Healthy, Unhealthy.
     */
    @JvmName("wobnikmeuawrrupn")
    public fun lastBackupStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LastBackupStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lastBackupStatus = mapped
    }

    /**
     * @param value Last backup operation status. Possible values: Healthy, Unhealthy.
     */
    @JvmName("sgpnvnqalppqnoui")
    public fun lastBackupStatus(`value`: LastBackupStatus) {
        val toBeMapped = Either.ofRight<String, LastBackupStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lastBackupStatus = mapped
    }

    /**
     * @param value Timestamp of the last backup operation on this backup item.
     */
    @JvmName("xygcxjjkdrtcihhs")
    public suspend fun lastBackupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastBackupTime = mapped
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("ulsvrduurvnkmrkr")
    public suspend fun lastRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRecoveryPoint = mapped
    }

    /**
     * @param value List of the nodes in case of distributed container.
     */
    @JvmName("bmvheihkldsjsvrp")
    public suspend fun nodesList(`value`: List<DistributedNodesInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodesList = mapped
    }

    /**
     * @param argument List of the nodes in case of distributed container.
     */
    @JvmName("doamklhhkyxxiune")
    public suspend fun nodesList(argument: List<suspend DistributedNodesInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributedNodesInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodesList = mapped
    }

    /**
     * @param argument List of the nodes in case of distributed container.
     */
    @JvmName("jeawsognvnsiklce")
    public suspend fun nodesList(
        vararg
        argument: suspend DistributedNodesInfoArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DistributedNodesInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodesList = mapped
    }

    /**
     * @param argument List of the nodes in case of distributed container.
     */
    @JvmName("xewciohbiolqqjpx")
    public suspend fun nodesList(argument: suspend DistributedNodesInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DistributedNodesInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nodesList = mapped
    }

    /**
     * @param values List of the nodes in case of distributed container.
     */
    @JvmName("rgerymebidtfqamp")
    public suspend fun nodesList(vararg values: DistributedNodesInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodesList = mapped
    }

    /**
     * @param value Parent name of the DB such as Instance or Availability Group.
     */
    @JvmName("vcospnngwycphqnd")
    public suspend fun parentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentName = mapped
    }

    /**
     * @param value Parent type of protected item, example: for a DB, standalone server or distributed
     */
    @JvmName("hmyjxvuvtstyofyc")
    public suspend fun parentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentType = mapped
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("nischsrpkwbetjvf")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("vcprotjxsqjmoujd")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Data ID of the protected item.
     */
    @JvmName("svdoguahqijstddr")
    public suspend fun protectedItemDataSourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemDataSourceId = mapped
    }

    /**
     * @param value Health status of the backup item, evaluated based on last heartbeat received
     */
    @JvmName("xcpnndlwfinnkbfc")
    public suspend
    fun protectedItemHealthStatus(`value`: Either<String, ProtectedItemHealthStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemHealthStatus = mapped
    }

    /**
     * @param value Health status of the backup item, evaluated based on last heartbeat received
     */
    @JvmName("kgdrtdycqhkngyag")
    public fun protectedItemHealthStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtectedItemHealthStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedItemHealthStatus = mapped
    }

    /**
     * @param value Health status of the backup item, evaluated based on last heartbeat received
     */
    @JvmName("frvlmigffvmcfqju")
    public fun protectedItemHealthStatus(`value`: ProtectedItemHealthStatus) {
        val toBeMapped = Either.ofRight<String, ProtectedItemHealthStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedItemHealthStatus = mapped
    }

    /**
     * @param value backup item type.
     * Expected value is 'AzureVmWorkloadSAPAseDatabase'.
     */
    @JvmName("kbsppgeplxdlbnik")
    public suspend fun protectedItemType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedItemType = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("ueandcvkbsgfhshk")
    public suspend fun protectionState(`value`: Either<String, ProtectionState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("nmaplrwoabrmnruw")
    public fun protectionState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtectionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("pthltoppdilkubxf")
    public fun protectionState(`value`: ProtectionState) {
        val toBeMapped = Either.ofRight<String, ProtectionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("hkqawephwmiktatv")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("chvhqtfkkabovxgr")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value Host/Cluster Name for instance or AG
     */
    @JvmName("gxpushobtlrdxyih")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("uvmmjetqprfqqnjl")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteRetentionPeriodInDays = mapped
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("frqtqdurmxkjtjlj")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    internal fun build(): AzureVmWorkloadSAPAseDatabaseProtectedItemArgs =
        AzureVmWorkloadSAPAseDatabaseProtectedItemArgs(
            backupSetName = backupSetName,
            containerName = containerName,
            createMode = createMode,
            deferredDeleteTimeInUTC = deferredDeleteTimeInUTC,
            deferredDeleteTimeRemaining = deferredDeleteTimeRemaining,
            extendedInfo = extendedInfo,
            isArchiveEnabled = isArchiveEnabled,
            isDeferredDeleteScheduleUpcoming = isDeferredDeleteScheduleUpcoming,
            isRehydrate = isRehydrate,
            isScheduledForDeferredDelete = isScheduledForDeferredDelete,
            kpisHealths = kpisHealths,
            lastBackupStatus = lastBackupStatus,
            lastBackupTime = lastBackupTime,
            lastRecoveryPoint = lastRecoveryPoint,
            nodesList = nodesList,
            parentName = parentName,
            parentType = parentType,
            policyId = policyId,
            policyName = policyName,
            protectedItemDataSourceId = protectedItemDataSourceId,
            protectedItemHealthStatus = protectedItemHealthStatus,
            protectedItemType = protectedItemType ?: throw PulumiNullFieldException("protectedItemType"),
            protectionState = protectionState,
            resourceGuardOperationRequests = resourceGuardOperationRequests,
            serverName = serverName,
            softDeleteRetentionPeriodInDays = softDeleteRetentionPeriodInDays,
            sourceResourceId = sourceResourceId,
        )
}
