@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.CmkKeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the Key Vault which hosts CMK
 * @property keyUri The key uri of the Customer Managed Key
 */
public data class CmkKeyVaultPropertiesArgs(
    public val keyUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.CmkKeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.CmkKeyVaultPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.CmkKeyVaultPropertiesArgs.builder()
            .keyUri(keyUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CmkKeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class CmkKeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyUri: Output<String>? = null

    /**
     * @param value The key uri of the Customer Managed Key
     */
    @JvmName("yawybcgsxofuafju")
    public suspend fun keyUri(`value`: Output<String>) {
        this.keyUri = value
    }

    /**
     * @param value The key uri of the Customer Managed Key
     */
    @JvmName("kssqigojyrqwofjn")
    public suspend fun keyUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyUri = mapped
    }

    internal fun build(): CmkKeyVaultPropertiesArgs = CmkKeyVaultPropertiesArgs(
        keyUri = keyUri,
    )
}
