@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.CreateNetworkMappingInputPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Common input details for network mapping operation.
 * @property fabricSpecificDetails Fabric specific input properties.
 * @property recoveryFabricName Recovery fabric Name.
 * @property recoveryNetworkId Recovery network Id.
 */
public data class CreateNetworkMappingInputPropertiesArgs(
    public val fabricSpecificDetails: Output<Any>? = null,
    public val recoveryFabricName: Output<String>? = null,
    public val recoveryNetworkId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.CreateNetworkMappingInputPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.CreateNetworkMappingInputPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.CreateNetworkMappingInputPropertiesArgs.builder()
            .fabricSpecificDetails(fabricSpecificDetails?.applyValue({ args0 -> args0 }))
            .recoveryFabricName(recoveryFabricName?.applyValue({ args0 -> args0 }))
            .recoveryNetworkId(recoveryNetworkId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreateNetworkMappingInputPropertiesArgs].
 */
@PulumiTagMarker
public class CreateNetworkMappingInputPropertiesArgsBuilder internal constructor() {
    private var fabricSpecificDetails: Output<Any>? = null

    private var recoveryFabricName: Output<String>? = null

    private var recoveryNetworkId: Output<String>? = null

    /**
     * @param value Fabric specific input properties.
     */
    @JvmName("hhthejttnxmtsojb")
    public suspend fun fabricSpecificDetails(`value`: Output<Any>) {
        this.fabricSpecificDetails = value
    }

    /**
     * @param value Recovery fabric Name.
     */
    @JvmName("waxobvjuguvwedyj")
    public suspend fun recoveryFabricName(`value`: Output<String>) {
        this.recoveryFabricName = value
    }

    /**
     * @param value Recovery network Id.
     */
    @JvmName("ogugewbjohejdjsn")
    public suspend fun recoveryNetworkId(`value`: Output<String>) {
        this.recoveryNetworkId = value
    }

    /**
     * @param value Fabric specific input properties.
     */
    @JvmName("fktfdentymxidjtf")
    public suspend fun fabricSpecificDetails(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricSpecificDetails = mapped
    }

    /**
     * @param value Recovery fabric Name.
     */
    @JvmName("hmjfgtakamscnfqd")
    public suspend fun recoveryFabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryFabricName = mapped
    }

    /**
     * @param value Recovery network Id.
     */
    @JvmName("mxyvmxermsrqvfae")
    public suspend fun recoveryNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryNetworkId = mapped
    }

    internal fun build(): CreateNetworkMappingInputPropertiesArgs =
        CreateNetworkMappingInputPropertiesArgs(
            fabricSpecificDetails = fabricSpecificDetails,
            recoveryFabricName = recoveryFabricName,
            recoveryNetworkId = recoveryNetworkId ?: throw PulumiNullFieldException("recoveryNetworkId"),
        )
}
