@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.CreatePolicyInputPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy creation properties.
 * @property providerSpecificInput The ReplicationProviderSettings.
 */
public data class CreatePolicyInputPropertiesArgs(
    public val providerSpecificInput: Output<Any>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.CreatePolicyInputPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.CreatePolicyInputPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.CreatePolicyInputPropertiesArgs.builder()
            .providerSpecificInput(providerSpecificInput?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreatePolicyInputPropertiesArgs].
 */
@PulumiTagMarker
public class CreatePolicyInputPropertiesArgsBuilder internal constructor() {
    private var providerSpecificInput: Output<Any>? = null

    /**
     * @param value The ReplicationProviderSettings.
     */
    @JvmName("xckqskgogqagxswy")
    public suspend fun providerSpecificInput(`value`: Output<Any>) {
        this.providerSpecificInput = value
    }

    /**
     * @param value The ReplicationProviderSettings.
     */
    @JvmName("fvgnyhoykokkktud")
    public suspend fun providerSpecificInput(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerSpecificInput = mapped
    }

    internal fun build(): CreatePolicyInputPropertiesArgs = CreatePolicyInputPropertiesArgs(
        providerSpecificInput = providerSpecificInput,
    )
}
