@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.CreateProtectionContainerMappingInputPropertiesArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configure pairing input properties.
 * @property policyId Applicable policy.
 * @property providerSpecificInput Provider specific input for pairing.
 * @property targetProtectionContainerId The target unique protection container name.
 */
public data class CreateProtectionContainerMappingInputPropertiesArgs(
    public val policyId: Output<String>? = null,
    public val providerSpecificInput:
    Output<Either<A2AContainerMappingInputArgs, VMwareCbtContainerMappingInputArgs>>? = null,
    public val targetProtectionContainerId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.CreateProtectionContainerMappingInputPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.CreateProtectionContainerMappingInputPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.CreateProtectionContainerMappingInputPropertiesArgs.builder()
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .providerSpecificInput(
                providerSpecificInput?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .targetProtectionContainerId(targetProtectionContainerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreateProtectionContainerMappingInputPropertiesArgs].
 */
@PulumiTagMarker
public class CreateProtectionContainerMappingInputPropertiesArgsBuilder internal constructor() {
    private var policyId: Output<String>? = null

    private var providerSpecificInput:
        Output<Either<A2AContainerMappingInputArgs, VMwareCbtContainerMappingInputArgs>>? = null

    private var targetProtectionContainerId: Output<String>? = null

    /**
     * @param value Applicable policy.
     */
    @JvmName("effxbbflcrskslar")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value Provider specific input for pairing.
     */
    @JvmName("fqhtdaxxhnvptgvq")
    public suspend
    fun providerSpecificInput(`value`: Output<Either<A2AContainerMappingInputArgs, VMwareCbtContainerMappingInputArgs>>) {
        this.providerSpecificInput = value
    }

    /**
     * @param value The target unique protection container name.
     */
    @JvmName("kllmkjpqxexiekps")
    public suspend fun targetProtectionContainerId(`value`: Output<String>) {
        this.targetProtectionContainerId = value
    }

    /**
     * @param value Applicable policy.
     */
    @JvmName("ldgrnlwjkxcoounc")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Provider specific input for pairing.
     */
    @JvmName("asnogvvlfsungrwy")
    public suspend
    fun providerSpecificInput(`value`: Either<A2AContainerMappingInputArgs, VMwareCbtContainerMappingInputArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerSpecificInput = mapped
    }

    /**
     * @param value Provider specific input for pairing.
     */
    @JvmName("nmgdtptwlsfafkeu")
    public fun providerSpecificInput(`value`: A2AContainerMappingInputArgs) {
        val toBeMapped = Either.ofLeft<A2AContainerMappingInputArgs,
            VMwareCbtContainerMappingInputArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerSpecificInput = mapped
    }

    /**
     * @param value Provider specific input for pairing.
     */
    @JvmName("acuycslnjyrqdbyd")
    public fun providerSpecificInput(`value`: VMwareCbtContainerMappingInputArgs) {
        val toBeMapped = Either.ofRight<A2AContainerMappingInputArgs,
            VMwareCbtContainerMappingInputArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerSpecificInput = mapped
    }

    /**
     * @param value The target unique protection container name.
     */
    @JvmName("xgrvoulqtgfvguva")
    public suspend fun targetProtectionContainerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetProtectionContainerId = mapped
    }

    internal fun build(): CreateProtectionContainerMappingInputPropertiesArgs =
        CreateProtectionContainerMappingInputPropertiesArgs(
            policyId = policyId,
            providerSpecificInput = providerSpecificInput,
            targetProtectionContainerId = targetProtectionContainerId,
        )
}
