@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.DiskEncryptionInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Recovery disk encryption info (BEK and KEK).
 * @property diskEncryptionKeyInfo The recovery KeyVault reference for secret.
 * @property keyEncryptionKeyInfo The recovery KeyVault reference for key.
 */
public data class DiskEncryptionInfoArgs(
    public val diskEncryptionKeyInfo: Output<DiskEncryptionKeyInfoArgs>? = null,
    public val keyEncryptionKeyInfo: Output<KeyEncryptionKeyInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.DiskEncryptionInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.DiskEncryptionInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.DiskEncryptionInfoArgs.builder()
            .diskEncryptionKeyInfo(
                diskEncryptionKeyInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .keyEncryptionKeyInfo(
                keyEncryptionKeyInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DiskEncryptionInfoArgs].
 */
@PulumiTagMarker
public class DiskEncryptionInfoArgsBuilder internal constructor() {
    private var diskEncryptionKeyInfo: Output<DiskEncryptionKeyInfoArgs>? = null

    private var keyEncryptionKeyInfo: Output<KeyEncryptionKeyInfoArgs>? = null

    /**
     * @param value The recovery KeyVault reference for secret.
     */
    @JvmName("tnuvckodotwwingd")
    public suspend fun diskEncryptionKeyInfo(`value`: Output<DiskEncryptionKeyInfoArgs>) {
        this.diskEncryptionKeyInfo = value
    }

    /**
     * @param value The recovery KeyVault reference for key.
     */
    @JvmName("vxvfatjpghrytphl")
    public suspend fun keyEncryptionKeyInfo(`value`: Output<KeyEncryptionKeyInfoArgs>) {
        this.keyEncryptionKeyInfo = value
    }

    /**
     * @param value The recovery KeyVault reference for secret.
     */
    @JvmName("xlfvcyvgxovgtwpl")
    public suspend fun diskEncryptionKeyInfo(`value`: DiskEncryptionKeyInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionKeyInfo = mapped
    }

    /**
     * @param argument The recovery KeyVault reference for secret.
     */
    @JvmName("vqdyfkhmhjkmfwpl")
    public suspend
    fun diskEncryptionKeyInfo(argument: suspend DiskEncryptionKeyInfoArgsBuilder.() -> Unit) {
        val toBeMapped = DiskEncryptionKeyInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskEncryptionKeyInfo = mapped
    }

    /**
     * @param value The recovery KeyVault reference for key.
     */
    @JvmName("bxddbirmxwwerkil")
    public suspend fun keyEncryptionKeyInfo(`value`: KeyEncryptionKeyInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKeyInfo = mapped
    }

    /**
     * @param argument The recovery KeyVault reference for key.
     */
    @JvmName("mgtaftlexcvmahqt")
    public suspend
    fun keyEncryptionKeyInfo(argument: suspend KeyEncryptionKeyInfoArgsBuilder.() -> Unit) {
        val toBeMapped = KeyEncryptionKeyInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyEncryptionKeyInfo = mapped
    }

    internal fun build(): DiskEncryptionInfoArgs = DiskEncryptionInfoArgs(
        diskEncryptionKeyInfo = diskEncryptionKeyInfo,
        keyEncryptionKeyInfo = keyEncryptionKeyInfo,
    )
}
