@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.DiskEncryptionKeyInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Disk Encryption Key Information (BitLocker Encryption Key (BEK) on Windows).
 * @property keyVaultResourceArmId The KeyVault resource ARM id for secret.
 * @property secretIdentifier The secret url / identifier.
 */
public data class DiskEncryptionKeyInfoArgs(
    public val keyVaultResourceArmId: Output<String>? = null,
    public val secretIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.DiskEncryptionKeyInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.DiskEncryptionKeyInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.DiskEncryptionKeyInfoArgs.builder()
            .keyVaultResourceArmId(keyVaultResourceArmId?.applyValue({ args0 -> args0 }))
            .secretIdentifier(secretIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskEncryptionKeyInfoArgs].
 */
@PulumiTagMarker
public class DiskEncryptionKeyInfoArgsBuilder internal constructor() {
    private var keyVaultResourceArmId: Output<String>? = null

    private var secretIdentifier: Output<String>? = null

    /**
     * @param value The KeyVault resource ARM id for secret.
     */
    @JvmName("vblbsimkpnadqcyo")
    public suspend fun keyVaultResourceArmId(`value`: Output<String>) {
        this.keyVaultResourceArmId = value
    }

    /**
     * @param value The secret url / identifier.
     */
    @JvmName("galmyhqipgyrhvqo")
    public suspend fun secretIdentifier(`value`: Output<String>) {
        this.secretIdentifier = value
    }

    /**
     * @param value The KeyVault resource ARM id for secret.
     */
    @JvmName("hguxjfggnniulytp")
    public suspend fun keyVaultResourceArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultResourceArmId = mapped
    }

    /**
     * @param value The secret url / identifier.
     */
    @JvmName("nvkxapyvqppopkkh")
    public suspend fun secretIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretIdentifier = mapped
    }

    internal fun build(): DiskEncryptionKeyInfoArgs = DiskEncryptionKeyInfoArgs(
        keyVaultResourceArmId = keyVaultResourceArmId,
        secretIdentifier = secretIdentifier,
    )
}
